package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codeguruprofiler.model.primitives.ProfilingGroupArn
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceArn: ProfilingGroupArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(ProfilingGroupArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.codeguruprofiler.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.ListTagsForResourceRequest =
      zio.aws.codeguruprofiler.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: ProfilingGroupArn
    def getResourceArn: ZIO[Any, Nothing, ProfilingGroupArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ListTagsForResourceRequest
  ) extends zio.aws.codeguruprofiler.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: ProfilingGroupArn =
      zio.aws.codeguruprofiler.model.primitives
        .ProfilingGroupArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ListTagsForResourceRequest
  ): zio.aws.codeguruprofiler.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
