package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeguruprofiler.model.primitives.Percentage
import scala.jdk.CollectionConverters._
final case class Pattern(
    countersToAggregate: Option[Iterable[String]] = None,
    description: Option[String] = None,
    id: Option[String] = None,
    name: Option[String] = None,
    resolutionSteps: Option[String] = None,
    targetFrames: Option[Iterable[Iterable[String]]] = None,
    thresholdPercent: Option[Percentage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.Pattern = {
    import Pattern.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.Pattern
      .builder()
      .optionallyWith(
        countersToAggregate.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.countersToAggregate)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(resolutionSteps.map(value => value: java.lang.String))(
        _.resolutionSteps
      )
      .optionallyWith(
        targetFrames.map(value =>
          value.map { item =>
            item.map { item =>
              item: java.lang.String
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.targetFrames)
      .optionallyWith(
        thresholdPercent.map(value =>
          Percentage.unwrap(value): java.lang.Double
        )
      )(_.thresholdPercent)
      .build()
  }
  def asReadOnly: zio.aws.codeguruprofiler.model.Pattern.ReadOnly =
    zio.aws.codeguruprofiler.model.Pattern.wrap(buildAwsValue())
}
object Pattern {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.Pattern
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.Pattern =
      zio.aws.codeguruprofiler.model.Pattern(
        countersToAggregate.map(value => value),
        description.map(value => value),
        id.map(value => value),
        name.map(value => value),
        resolutionSteps.map(value => value),
        targetFrames.map(value => value),
        thresholdPercent.map(value => value)
      )
    def countersToAggregate: Option[List[String]]
    def description: Option[String]
    def id: Option[String]
    def name: Option[String]
    def resolutionSteps: Option[String]
    def targetFrames: Option[List[List[String]]]
    def thresholdPercent: Option[Percentage]
    def getCountersToAggregate: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("countersToAggregate", countersToAggregate)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getResolutionSteps: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resolutionSteps", resolutionSteps)
    def getTargetFrames: ZIO[Any, AwsError, List[List[String]]] =
      AwsError.unwrapOptionField("targetFrames", targetFrames)
    def getThresholdPercent: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("thresholdPercent", thresholdPercent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.Pattern
  ) extends zio.aws.codeguruprofiler.model.Pattern.ReadOnly {
    override val countersToAggregate: Option[List[String]] = scala
      .Option(impl.countersToAggregate())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val id: Option[String] =
      scala.Option(impl.id()).map(value => value: String)
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val resolutionSteps: Option[String] =
      scala.Option(impl.resolutionSteps()).map(value => value: String)
    override val targetFrames: Option[List[List[String]]] = scala
      .Option(impl.targetFrames())
      .map(value =>
        value.asScala.map { item =>
          item.asScala.map { item =>
            item: String
          }.toList
        }.toList
      )
    override val thresholdPercent: Option[Percentage] = scala
      .Option(impl.thresholdPercent())
      .map(value => zio.aws.codeguruprofiler.model.primitives.Percentage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.Pattern
  ): zio.aws.codeguruprofiler.model.Pattern.ReadOnly = new Wrapper(impl)
}
