package zio.aws.codeguruprofiler.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeguruprofiler.model.primitives.{PaginationToken, MaxResults}
import scala.jdk.CollectionConverters._
final case class ListProfilingGroupsRequest(
    includeDescription: Option[Boolean] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest = {
    import ListProfilingGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest
      .builder()
      .optionallyWith(
        includeDescription.map(value => value: java.lang.Boolean)
      )(_.includeDescription)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.ListProfilingGroupsRequest.ReadOnly =
    zio.aws.codeguruprofiler.model.ListProfilingGroupsRequest
      .wrap(buildAwsValue())
}
object ListProfilingGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.ListProfilingGroupsRequest =
      zio.aws.codeguruprofiler.model.ListProfilingGroupsRequest(
        includeDescription.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def includeDescription: Option[Boolean]
    def maxResults: Option[MaxResults]
    def nextToken: Option[PaginationToken]
    def getIncludeDescription: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeDescription", includeDescription)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest
  ) extends zio.aws.codeguruprofiler.model.ListProfilingGroupsRequest.ReadOnly {
    override val includeDescription: Option[Boolean] =
      scala.Option(impl.includeDescription()).map(value => value: Boolean)
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.codeguruprofiler.model.primitives.MaxResults(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.codeguruprofiler.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest
  ): zio.aws.codeguruprofiler.model.ListProfilingGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
