package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeguruprofiler.model.primitives.{ChannelUri, ChannelId}
import scala.jdk.CollectionConverters._
final case class Channel(
    eventPublishers: Iterable[zio.aws.codeguruprofiler.model.EventPublisher],
    id: Option[ChannelId] = None,
    uri: ChannelUri
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.Channel = {
    import Channel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.Channel
      .builder()
      .eventPublishersWithStrings(eventPublishers.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        id.map(value => ChannelId.unwrap(value): java.lang.String)
      )(_.id)
      .uri(ChannelUri.unwrap(uri): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codeguruprofiler.model.Channel.ReadOnly =
    zio.aws.codeguruprofiler.model.Channel.wrap(buildAwsValue())
}
object Channel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.Channel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.Channel =
      zio.aws.codeguruprofiler.model
        .Channel(eventPublishers, id.map(value => value), uri)
    def eventPublishers: List[zio.aws.codeguruprofiler.model.EventPublisher]
    def id: Option[ChannelId]
    def uri: ChannelUri
    def getEventPublishers: ZIO[Any, Nothing, List[
      zio.aws.codeguruprofiler.model.EventPublisher
    ]] = ZIO.succeed(eventPublishers)
    def getId: ZIO[Any, AwsError, ChannelId] =
      AwsError.unwrapOptionField("id", id)
    def getUri: ZIO[Any, Nothing, ChannelUri] = ZIO.succeed(uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.Channel
  ) extends zio.aws.codeguruprofiler.model.Channel.ReadOnly {
    override val eventPublishers
        : List[zio.aws.codeguruprofiler.model.EventPublisher] = impl
      .eventPublishers()
      .asScala
      .map { item =>
        zio.aws.codeguruprofiler.model.EventPublisher.wrap(item)
      }
      .toList
    override val id: Option[ChannelId] = scala
      .Option(impl.id())
      .map(value => zio.aws.codeguruprofiler.model.primitives.ChannelId(value))
    override val uri: ChannelUri =
      zio.aws.codeguruprofiler.model.primitives.ChannelUri(impl.uri())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.Channel
  ): zio.aws.codeguruprofiler.model.Channel.ReadOnly = new Wrapper(impl)
}
