package zio.aws.codeguruprofiler
import zio.aws.codeguruprofiler.model.ProfileTime.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.codeguruprofiler.model.{
  GetProfileRequest,
  ListFindingsReportsRequest,
  GetFindingsReportAccountSummaryRequest,
  ConfigureAgentRequest,
  ListProfileTimesRequest,
  ListProfilingGroupsRequest,
  BatchGetFrameMetricDataRequest,
  PutPermissionRequest,
  ListTagsForResourceRequest,
  GetRecommendationsRequest,
  CreateProfilingGroupRequest,
  AddNotificationChannelsRequest,
  DeleteProfilingGroupRequest,
  PostAgentProfileRequest,
  GetNotificationConfigurationRequest,
  GetPolicyRequest,
  UntagResourceRequest,
  UpdateProfilingGroupRequest,
  SubmitFeedbackRequest,
  DescribeProfilingGroupRequest,
  RemovePermissionRequest,
  TagResourceRequest,
  RemoveNotificationChannelRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.codeguruprofiler.model.{
  UpdateProfilingGroupResponse,
  ListProfileTimesResponse,
  DeleteProfilingGroupResponse,
  PutPermissionResponse,
  ListProfilingGroupsResponse,
  RemovePermissionResponse,
  SubmitFeedbackResponse,
  GetRecommendationsResponse,
  GetProfileResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  GetPolicyResponse,
  ProfileTime,
  RemoveNotificationChannelResponse,
  ConfigureAgentResponse,
  BatchGetFrameMetricDataResponse,
  DescribeProfilingGroupResponse,
  CreateProfilingGroupResponse,
  PostAgentProfileResponse,
  GetFindingsReportAccountSummaryResponse,
  ListFindingsReportsResponse,
  TagResourceResponse,
  GetNotificationConfigurationResponse,
  AddNotificationChannelsResponse
}
import software.amazon.awssdk.services.codeguruprofiler.{
  CodeGuruProfilerAsyncClientBuilder,
  CodeGuruProfilerAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfileTimesPublisher
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait CodeGuruProfiler extends AspectSupport[CodeGuruProfiler] {
  val api: CodeGuruProfilerAsyncClient
  def listProfilingGroups(request: ListProfilingGroupsRequest): IO[
    AwsError,
    zio.aws.codeguruprofiler.model.ListProfilingGroupsResponse.ReadOnly
  ]
  def createProfilingGroup(request: CreateProfilingGroupRequest): IO[
    AwsError,
    zio.aws.codeguruprofiler.model.CreateProfilingGroupResponse.ReadOnly
  ]
  def putPermission(
      request: PutPermissionRequest
  ): IO[AwsError, zio.aws.codeguruprofiler.model.PutPermissionResponse.ReadOnly]
  def configureAgent(request: ConfigureAgentRequest): IO[
    AwsError,
    zio.aws.codeguruprofiler.model.ConfigureAgentResponse.ReadOnly
  ]
  def listFindingsReports(request: ListFindingsReportsRequest): IO[
    AwsError,
    zio.aws.codeguruprofiler.model.ListFindingsReportsResponse.ReadOnly
  ]
  def addNotificationChannels(request: AddNotificationChannelsRequest): IO[
    AwsError,
    zio.aws.codeguruprofiler.model.AddNotificationChannelsResponse.ReadOnly
  ]
  def getRecommendations(request: GetRecommendationsRequest): IO[
    AwsError,
    zio.aws.codeguruprofiler.model.GetRecommendationsResponse.ReadOnly
  ]
  def describeProfilingGroup(request: DescribeProfilingGroupRequest): IO[
    AwsError,
    zio.aws.codeguruprofiler.model.DescribeProfilingGroupResponse.ReadOnly
  ]
  def postAgentProfile(request: PostAgentProfileRequest): IO[
    AwsError,
    zio.aws.codeguruprofiler.model.PostAgentProfileResponse.ReadOnly
  ]
  def submitFeedback(request: SubmitFeedbackRequest): IO[
    AwsError,
    zio.aws.codeguruprofiler.model.SubmitFeedbackResponse.ReadOnly
  ]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.codeguruprofiler.model.UntagResourceResponse.ReadOnly]
  def deleteProfilingGroup(request: DeleteProfilingGroupRequest): IO[
    AwsError,
    zio.aws.codeguruprofiler.model.DeleteProfilingGroupResponse.ReadOnly
  ]
  def getProfile(
      request: GetProfileRequest
  ): IO[AwsError, zio.aws.codeguruprofiler.model.GetProfileResponse.ReadOnly]
  def removePermission(request: RemovePermissionRequest): IO[
    AwsError,
    zio.aws.codeguruprofiler.model.RemovePermissionResponse.ReadOnly
  ]
  def removeNotificationChannel(request: RemoveNotificationChannelRequest): IO[
    AwsError,
    zio.aws.codeguruprofiler.model.RemoveNotificationChannelResponse.ReadOnly
  ]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.codeguruprofiler.model.ListTagsForResourceResponse.ReadOnly
  ]
  def listProfileTimes(
      request: ListProfileTimesRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def listProfileTimesPaginated(request: ListProfileTimesRequest): IO[
    AwsError,
    zio.aws.codeguruprofiler.model.ListProfileTimesResponse.ReadOnly
  ]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.codeguruprofiler.model.TagResourceResponse.ReadOnly]
  def batchGetFrameMetricData(request: BatchGetFrameMetricDataRequest): IO[
    AwsError,
    zio.aws.codeguruprofiler.model.BatchGetFrameMetricDataResponse.ReadOnly
  ]
  def getPolicy(
      request: GetPolicyRequest
  ): IO[AwsError, zio.aws.codeguruprofiler.model.GetPolicyResponse.ReadOnly]
  def updateProfilingGroup(request: UpdateProfilingGroupRequest): IO[
    AwsError,
    zio.aws.codeguruprofiler.model.UpdateProfilingGroupResponse.ReadOnly
  ]
  def getNotificationConfiguration(
      request: GetNotificationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.codeguruprofiler.model.GetNotificationConfigurationResponse.ReadOnly
  ]
  def getFindingsReportAccountSummary(
      request: GetFindingsReportAccountSummaryRequest
  ): IO[
    AwsError,
    zio.aws.codeguruprofiler.model.GetFindingsReportAccountSummaryResponse.ReadOnly
  ]
}
object CodeGuruProfiler {
  val live: ZLayer[AwsConfig, java.lang.Throwable, CodeGuruProfiler] =
    customized(identity)
  def customized(
      customization: CodeGuruProfilerAsyncClientBuilder => CodeGuruProfilerAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, CodeGuruProfiler] = managed(
    customization
  ).toLayer
  def managed(
      customization: CodeGuruProfilerAsyncClientBuilder => CodeGuruProfilerAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, CodeGuruProfiler] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = CodeGuruProfilerAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[
        CodeGuruProfilerAsyncClient,
        CodeGuruProfilerAsyncClientBuilder
      ](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        CodeGuruProfilerAsyncClient,
        CodeGuruProfilerAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new CodeGuruProfilerImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class CodeGuruProfilerImpl[R](
      override val api: CodeGuruProfilerAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends CodeGuruProfiler
      with AwsServiceBase[R] {
    override val serviceName: String = "CodeGuruProfiler"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): CodeGuruProfilerImpl[R1] = new CodeGuruProfilerImpl(api, newAspect, r)
    def listProfilingGroups(request: ListProfilingGroupsRequest): IO[
      AwsError,
      zio.aws.codeguruprofiler.model.ListProfilingGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest,
      ListProfilingGroupsResponse
    ]("listProfilingGroups", api.listProfilingGroups)(request.buildAwsValue())
      .map(zio.aws.codeguruprofiler.model.ListProfilingGroupsResponse.wrap)
      .provideEnvironment(r)
    def createProfilingGroup(request: CreateProfilingGroupRequest): IO[
      AwsError,
      zio.aws.codeguruprofiler.model.CreateProfilingGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codeguruprofiler.model.CreateProfilingGroupRequest,
      CreateProfilingGroupResponse
    ]("createProfilingGroup", api.createProfilingGroup)(request.buildAwsValue())
      .map(zio.aws.codeguruprofiler.model.CreateProfilingGroupResponse.wrap)
      .provideEnvironment(r)
    def putPermission(request: PutPermissionRequest): IO[
      AwsError,
      zio.aws.codeguruprofiler.model.PutPermissionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codeguruprofiler.model.PutPermissionRequest,
      PutPermissionResponse
    ]("putPermission", api.putPermission)(request.buildAwsValue())
      .map(zio.aws.codeguruprofiler.model.PutPermissionResponse.wrap)
      .provideEnvironment(r)
    def configureAgent(request: ConfigureAgentRequest): IO[
      AwsError,
      zio.aws.codeguruprofiler.model.ConfigureAgentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codeguruprofiler.model.ConfigureAgentRequest,
      ConfigureAgentResponse
    ]("configureAgent", api.configureAgent)(request.buildAwsValue())
      .map(zio.aws.codeguruprofiler.model.ConfigureAgentResponse.wrap)
      .provideEnvironment(r)
    def listFindingsReports(request: ListFindingsReportsRequest): IO[
      AwsError,
      zio.aws.codeguruprofiler.model.ListFindingsReportsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codeguruprofiler.model.ListFindingsReportsRequest,
      ListFindingsReportsResponse
    ]("listFindingsReports", api.listFindingsReports)(request.buildAwsValue())
      .map(zio.aws.codeguruprofiler.model.ListFindingsReportsResponse.wrap)
      .provideEnvironment(r)
    def addNotificationChannels(request: AddNotificationChannelsRequest): IO[
      AwsError,
      zio.aws.codeguruprofiler.model.AddNotificationChannelsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codeguruprofiler.model.AddNotificationChannelsRequest,
      AddNotificationChannelsResponse
    ]("addNotificationChannels", api.addNotificationChannels)(
      request.buildAwsValue()
    ).map(zio.aws.codeguruprofiler.model.AddNotificationChannelsResponse.wrap)
      .provideEnvironment(r)
    def getRecommendations(request: GetRecommendationsRequest): IO[
      AwsError,
      zio.aws.codeguruprofiler.model.GetRecommendationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codeguruprofiler.model.GetRecommendationsRequest,
      GetRecommendationsResponse
    ]("getRecommendations", api.getRecommendations)(request.buildAwsValue())
      .map(zio.aws.codeguruprofiler.model.GetRecommendationsResponse.wrap)
      .provideEnvironment(r)
    def describeProfilingGroup(request: DescribeProfilingGroupRequest): IO[
      AwsError,
      zio.aws.codeguruprofiler.model.DescribeProfilingGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codeguruprofiler.model.DescribeProfilingGroupRequest,
      DescribeProfilingGroupResponse
    ]("describeProfilingGroup", api.describeProfilingGroup)(
      request.buildAwsValue()
    ).map(zio.aws.codeguruprofiler.model.DescribeProfilingGroupResponse.wrap)
      .provideEnvironment(r)
    def postAgentProfile(request: PostAgentProfileRequest): IO[
      AwsError,
      zio.aws.codeguruprofiler.model.PostAgentProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codeguruprofiler.model.PostAgentProfileRequest,
      PostAgentProfileResponse
    ]("postAgentProfile", api.postAgentProfile)(request.buildAwsValue())
      .map(zio.aws.codeguruprofiler.model.PostAgentProfileResponse.wrap)
      .provideEnvironment(r)
    def submitFeedback(request: SubmitFeedbackRequest): IO[
      AwsError,
      zio.aws.codeguruprofiler.model.SubmitFeedbackResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codeguruprofiler.model.SubmitFeedbackRequest,
      SubmitFeedbackResponse
    ]("submitFeedback", api.submitFeedback)(request.buildAwsValue())
      .map(zio.aws.codeguruprofiler.model.SubmitFeedbackResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.codeguruprofiler.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codeguruprofiler.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.codeguruprofiler.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def deleteProfilingGroup(request: DeleteProfilingGroupRequest): IO[
      AwsError,
      zio.aws.codeguruprofiler.model.DeleteProfilingGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codeguruprofiler.model.DeleteProfilingGroupRequest,
      DeleteProfilingGroupResponse
    ]("deleteProfilingGroup", api.deleteProfilingGroup)(request.buildAwsValue())
      .map(zio.aws.codeguruprofiler.model.DeleteProfilingGroupResponse.wrap)
      .provideEnvironment(r)
    def getProfile(request: GetProfileRequest): IO[
      AwsError,
      zio.aws.codeguruprofiler.model.GetProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codeguruprofiler.model.GetProfileRequest,
      GetProfileResponse
    ]("getProfile", api.getProfile)(request.buildAwsValue())
      .map(zio.aws.codeguruprofiler.model.GetProfileResponse.wrap)
      .provideEnvironment(r)
    def removePermission(request: RemovePermissionRequest): IO[
      AwsError,
      zio.aws.codeguruprofiler.model.RemovePermissionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codeguruprofiler.model.RemovePermissionRequest,
      RemovePermissionResponse
    ]("removePermission", api.removePermission)(request.buildAwsValue())
      .map(zio.aws.codeguruprofiler.model.RemovePermissionResponse.wrap)
      .provideEnvironment(r)
    def removeNotificationChannel(
        request: RemoveNotificationChannelRequest
    ): IO[
      AwsError,
      zio.aws.codeguruprofiler.model.RemoveNotificationChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codeguruprofiler.model.RemoveNotificationChannelRequest,
      RemoveNotificationChannelResponse
    ]("removeNotificationChannel", api.removeNotificationChannel)(
      request.buildAwsValue()
    ).map(zio.aws.codeguruprofiler.model.RemoveNotificationChannelResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.codeguruprofiler.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codeguruprofiler.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.codeguruprofiler.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def listProfileTimes(
        request: ListProfileTimesRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesRequest,
      ProfileTime,
      ListProfileTimesPublisher
    ]("listProfileTimes", api.listProfileTimesPaginator, _.profileTimes())(
      request.buildAwsValue()
    ).map(item => zio.aws.codeguruprofiler.model.ProfileTime.wrap(item))
      .provideEnvironment(r)
    def listProfileTimesPaginated(request: ListProfileTimesRequest): IO[
      AwsError,
      zio.aws.codeguruprofiler.model.ListProfileTimesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesRequest,
      ListProfileTimesResponse
    ]("listProfileTimes", api.listProfileTimes)(request.buildAwsValue())
      .map(zio.aws.codeguruprofiler.model.ListProfileTimesResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      zio.aws.codeguruprofiler.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codeguruprofiler.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(zio.aws.codeguruprofiler.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def batchGetFrameMetricData(request: BatchGetFrameMetricDataRequest): IO[
      AwsError,
      zio.aws.codeguruprofiler.model.BatchGetFrameMetricDataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codeguruprofiler.model.BatchGetFrameMetricDataRequest,
      BatchGetFrameMetricDataResponse
    ]("batchGetFrameMetricData", api.batchGetFrameMetricData)(
      request.buildAwsValue()
    ).map(zio.aws.codeguruprofiler.model.BatchGetFrameMetricDataResponse.wrap)
      .provideEnvironment(r)
    def getPolicy(
        request: GetPolicyRequest
    ): IO[AwsError, zio.aws.codeguruprofiler.model.GetPolicyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codeguruprofiler.model.GetPolicyRequest,
        GetPolicyResponse
      ]("getPolicy", api.getPolicy)(request.buildAwsValue())
        .map(zio.aws.codeguruprofiler.model.GetPolicyResponse.wrap)
        .provideEnvironment(r)
    def updateProfilingGroup(request: UpdateProfilingGroupRequest): IO[
      AwsError,
      zio.aws.codeguruprofiler.model.UpdateProfilingGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codeguruprofiler.model.UpdateProfilingGroupRequest,
      UpdateProfilingGroupResponse
    ]("updateProfilingGroup", api.updateProfilingGroup)(request.buildAwsValue())
      .map(zio.aws.codeguruprofiler.model.UpdateProfilingGroupResponse.wrap)
      .provideEnvironment(r)
    def getNotificationConfiguration(
        request: GetNotificationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.codeguruprofiler.model.GetNotificationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codeguruprofiler.model.GetNotificationConfigurationRequest,
      GetNotificationConfigurationResponse
    ]("getNotificationConfiguration", api.getNotificationConfiguration)(
      request.buildAwsValue()
    ).map(
      zio.aws.codeguruprofiler.model.GetNotificationConfigurationResponse.wrap
    ).provideEnvironment(r)
    def getFindingsReportAccountSummary(
        request: GetFindingsReportAccountSummaryRequest
    ): IO[
      AwsError,
      zio.aws.codeguruprofiler.model.GetFindingsReportAccountSummaryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codeguruprofiler.model.GetFindingsReportAccountSummaryRequest,
      GetFindingsReportAccountSummaryResponse
    ]("getFindingsReportAccountSummary", api.getFindingsReportAccountSummary)(
      request.buildAwsValue()
    ).map(
      zio.aws.codeguruprofiler.model.GetFindingsReportAccountSummaryResponse.wrap
    ).provideEnvironment(r)
  }
  def listProfilingGroups(request: ListProfilingGroupsRequest): ZIO[
    zio.aws.codeguruprofiler.CodeGuruProfiler,
    AwsError,
    zio.aws.codeguruprofiler.model.ListProfilingGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProfilingGroups(request))
  def createProfilingGroup(request: CreateProfilingGroupRequest): ZIO[
    zio.aws.codeguruprofiler.CodeGuruProfiler,
    AwsError,
    zio.aws.codeguruprofiler.model.CreateProfilingGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProfilingGroup(request))
  def putPermission(request: PutPermissionRequest): ZIO[
    zio.aws.codeguruprofiler.CodeGuruProfiler,
    AwsError,
    zio.aws.codeguruprofiler.model.PutPermissionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putPermission(request))
  def configureAgent(request: ConfigureAgentRequest): ZIO[
    zio.aws.codeguruprofiler.CodeGuruProfiler,
    AwsError,
    zio.aws.codeguruprofiler.model.ConfigureAgentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.configureAgent(request))
  def listFindingsReports(request: ListFindingsReportsRequest): ZIO[
    zio.aws.codeguruprofiler.CodeGuruProfiler,
    AwsError,
    zio.aws.codeguruprofiler.model.ListFindingsReportsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFindingsReports(request))
  def addNotificationChannels(request: AddNotificationChannelsRequest): ZIO[
    zio.aws.codeguruprofiler.CodeGuruProfiler,
    AwsError,
    zio.aws.codeguruprofiler.model.AddNotificationChannelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addNotificationChannels(request))
  def getRecommendations(request: GetRecommendationsRequest): ZIO[
    zio.aws.codeguruprofiler.CodeGuruProfiler,
    AwsError,
    zio.aws.codeguruprofiler.model.GetRecommendationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRecommendations(request))
  def describeProfilingGroup(request: DescribeProfilingGroupRequest): ZIO[
    zio.aws.codeguruprofiler.CodeGuruProfiler,
    AwsError,
    zio.aws.codeguruprofiler.model.DescribeProfilingGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeProfilingGroup(request))
  def postAgentProfile(request: PostAgentProfileRequest): ZIO[
    zio.aws.codeguruprofiler.CodeGuruProfiler,
    AwsError,
    zio.aws.codeguruprofiler.model.PostAgentProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.postAgentProfile(request))
  def submitFeedback(request: SubmitFeedbackRequest): ZIO[
    zio.aws.codeguruprofiler.CodeGuruProfiler,
    AwsError,
    zio.aws.codeguruprofiler.model.SubmitFeedbackResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.submitFeedback(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.codeguruprofiler.CodeGuruProfiler,
    AwsError,
    zio.aws.codeguruprofiler.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def deleteProfilingGroup(request: DeleteProfilingGroupRequest): ZIO[
    zio.aws.codeguruprofiler.CodeGuruProfiler,
    AwsError,
    zio.aws.codeguruprofiler.model.DeleteProfilingGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteProfilingGroup(request))
  def getProfile(request: GetProfileRequest): ZIO[
    zio.aws.codeguruprofiler.CodeGuruProfiler,
    AwsError,
    zio.aws.codeguruprofiler.model.GetProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getProfile(request))
  def removePermission(request: RemovePermissionRequest): ZIO[
    zio.aws.codeguruprofiler.CodeGuruProfiler,
    AwsError,
    zio.aws.codeguruprofiler.model.RemovePermissionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removePermission(request))
  def removeNotificationChannel(request: RemoveNotificationChannelRequest): ZIO[
    zio.aws.codeguruprofiler.CodeGuruProfiler,
    AwsError,
    zio.aws.codeguruprofiler.model.RemoveNotificationChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeNotificationChannel(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.codeguruprofiler.CodeGuruProfiler,
    AwsError,
    zio.aws.codeguruprofiler.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def listProfileTimes(
      request: ListProfileTimesRequest
  ): ZStream[zio.aws.codeguruprofiler.CodeGuruProfiler, AwsError, ReadOnly] =
    ZStream.serviceWithStream(_.listProfileTimes(request))
  def listProfileTimesPaginated(request: ListProfileTimesRequest): ZIO[
    zio.aws.codeguruprofiler.CodeGuruProfiler,
    AwsError,
    zio.aws.codeguruprofiler.model.ListProfileTimesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProfileTimesPaginated(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.codeguruprofiler.CodeGuruProfiler,
    AwsError,
    zio.aws.codeguruprofiler.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def batchGetFrameMetricData(request: BatchGetFrameMetricDataRequest): ZIO[
    zio.aws.codeguruprofiler.CodeGuruProfiler,
    AwsError,
    zio.aws.codeguruprofiler.model.BatchGetFrameMetricDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetFrameMetricData(request))
  def getPolicy(request: GetPolicyRequest): ZIO[
    zio.aws.codeguruprofiler.CodeGuruProfiler,
    AwsError,
    zio.aws.codeguruprofiler.model.GetPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPolicy(request))
  def updateProfilingGroup(request: UpdateProfilingGroupRequest): ZIO[
    zio.aws.codeguruprofiler.CodeGuruProfiler,
    AwsError,
    zio.aws.codeguruprofiler.model.UpdateProfilingGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateProfilingGroup(request))
  def getNotificationConfiguration(
      request: GetNotificationConfigurationRequest
  ): ZIO[
    zio.aws.codeguruprofiler.CodeGuruProfiler,
    AwsError,
    zio.aws.codeguruprofiler.model.GetNotificationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getNotificationConfiguration(request))
  def getFindingsReportAccountSummary(
      request: GetFindingsReportAccountSummaryRequest
  ): ZIO[
    zio.aws.codeguruprofiler.CodeGuruProfiler,
    AwsError,
    zio.aws.codeguruprofiler.model.GetFindingsReportAccountSummaryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFindingsReportAccountSummary(request))
}
