package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codeguruprofiler.model.primitives.ProfilingGroupName
import scala.jdk.CollectionConverters._
final case class UpdateProfilingGroupRequest(
    agentOrchestrationConfig: zio.aws.codeguruprofiler.model.AgentOrchestrationConfig,
    profilingGroupName: ProfilingGroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.UpdateProfilingGroupRequest = {
    import UpdateProfilingGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.UpdateProfilingGroupRequest
      .builder()
      .agentOrchestrationConfig(agentOrchestrationConfig.buildAwsValue())
      .profilingGroupName(
        ProfilingGroupName.unwrap(profilingGroupName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.UpdateProfilingGroupRequest.ReadOnly =
    zio.aws.codeguruprofiler.model.UpdateProfilingGroupRequest
      .wrap(buildAwsValue())
}
object UpdateProfilingGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.UpdateProfilingGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.UpdateProfilingGroupRequest =
      zio.aws.codeguruprofiler.model.UpdateProfilingGroupRequest(
        agentOrchestrationConfig.asEditable,
        profilingGroupName
      )
    def agentOrchestrationConfig
        : zio.aws.codeguruprofiler.model.AgentOrchestrationConfig.ReadOnly
    def profilingGroupName: ProfilingGroupName
    def getAgentOrchestrationConfig: ZIO[
      Any,
      Nothing,
      zio.aws.codeguruprofiler.model.AgentOrchestrationConfig.ReadOnly
    ] = ZIO.succeed(agentOrchestrationConfig)
    def getProfilingGroupName: ZIO[Any, Nothing, ProfilingGroupName] =
      ZIO.succeed(profilingGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.UpdateProfilingGroupRequest
  ) extends zio.aws.codeguruprofiler.model.UpdateProfilingGroupRequest.ReadOnly {
    override val agentOrchestrationConfig
        : zio.aws.codeguruprofiler.model.AgentOrchestrationConfig.ReadOnly =
      zio.aws.codeguruprofiler.model.AgentOrchestrationConfig
        .wrap(impl.agentOrchestrationConfig())
    override val profilingGroupName: ProfilingGroupName =
      zio.aws.codeguruprofiler.model.primitives
        .ProfilingGroupName(impl.profilingGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.UpdateProfilingGroupRequest
  ): zio.aws.codeguruprofiler.model.UpdateProfilingGroupRequest.ReadOnly =
    new Wrapper(impl)
}
