package zio.aws.codeguruprofiler.model
import zio.aws.codeguruprofiler.model.primitives.{
  Integer,
  Timestamp,
  FindingsReportId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class FindingsReportSummary(
    id: Optional[FindingsReportId] = Optional.Absent,
    profileEndTime: Optional[Timestamp] = Optional.Absent,
    profileStartTime: Optional[Timestamp] = Optional.Absent,
    profilingGroupName: Optional[String] = Optional.Absent,
    totalNumberOfFindings: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.FindingsReportSummary = {
    import FindingsReportSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.FindingsReportSummary
      .builder()
      .optionallyWith(
        id.map(value => FindingsReportId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        profileEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.profileEndTime)
      .optionallyWith(
        profileStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.profileStartTime)
      .optionallyWith(profilingGroupName.map(value => value: java.lang.String))(
        _.profilingGroupName
      )
      .optionallyWith(
        totalNumberOfFindings.map(value => value: java.lang.Integer)
      )(_.totalNumberOfFindings)
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.FindingsReportSummary.ReadOnly =
    zio.aws.codeguruprofiler.model.FindingsReportSummary.wrap(buildAwsValue())
}
object FindingsReportSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.FindingsReportSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.FindingsReportSummary =
      zio.aws.codeguruprofiler.model.FindingsReportSummary(
        id.map(value => value),
        profileEndTime.map(value => value),
        profileStartTime.map(value => value),
        profilingGroupName.map(value => value),
        totalNumberOfFindings.map(value => value)
      )
    def id: Optional[FindingsReportId]
    def profileEndTime: Optional[Timestamp]
    def profileStartTime: Optional[Timestamp]
    def profilingGroupName: Optional[String]
    def totalNumberOfFindings: Optional[Integer]
    def getId: ZIO[Any, AwsError, FindingsReportId] =
      AwsError.unwrapOptionField("id", id)
    def getProfileEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("profileEndTime", profileEndTime)
    def getProfileStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("profileStartTime", profileStartTime)
    def getProfilingGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("profilingGroupName", profilingGroupName)
    def getTotalNumberOfFindings: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalNumberOfFindings", totalNumberOfFindings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.FindingsReportSummary
  ) extends zio.aws.codeguruprofiler.model.FindingsReportSummary.ReadOnly {
    override val id: Optional[FindingsReportId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.codeguruprofiler.model.primitives.FindingsReportId(value)
      )
    override val profileEndTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.profileEndTime())
      .map(value => zio.aws.codeguruprofiler.model.primitives.Timestamp(value))
    override val profileStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.profileStartTime())
      .map(value => zio.aws.codeguruprofiler.model.primitives.Timestamp(value))
    override val profilingGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.profilingGroupName())
      .map(value => value: String)
    override val totalNumberOfFindings: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalNumberOfFindings())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.FindingsReportSummary
  ): zio.aws.codeguruprofiler.model.FindingsReportSummary.ReadOnly =
    new Wrapper(impl)
}
