package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeguruprofiler.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class Match(
    frameAddress: Optional[String] = Optional.Absent,
    targetFramesIndex: Optional[Integer] = Optional.Absent,
    thresholdBreachValue: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.Match = {
    import Match.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.Match
      .builder()
      .optionallyWith(frameAddress.map(value => value: java.lang.String))(
        _.frameAddress
      )
      .optionallyWith(targetFramesIndex.map(value => value: java.lang.Integer))(
        _.targetFramesIndex
      )
      .optionallyWith(
        thresholdBreachValue.map(value => value: java.lang.Double)
      )(_.thresholdBreachValue)
      .build()
  }
  def asReadOnly: zio.aws.codeguruprofiler.model.Match.ReadOnly =
    zio.aws.codeguruprofiler.model.Match.wrap(buildAwsValue())
}
object Match {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.Match
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.Match =
      zio.aws.codeguruprofiler.model.Match(
        frameAddress.map(value => value),
        targetFramesIndex.map(value => value),
        thresholdBreachValue.map(value => value)
      )
    def frameAddress: Optional[String]
    def targetFramesIndex: Optional[Integer]
    def thresholdBreachValue: Optional[Double]
    def getFrameAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("frameAddress", frameAddress)
    def getTargetFramesIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("targetFramesIndex", targetFramesIndex)
    def getThresholdBreachValue: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("thresholdBreachValue", thresholdBreachValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.Match
  ) extends zio.aws.codeguruprofiler.model.Match.ReadOnly {
    override val frameAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.frameAddress())
      .map(value => value: String)
    override val targetFramesIndex: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.targetFramesIndex())
      .map(value => value: Integer)
    override val thresholdBreachValue: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.thresholdBreachValue())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.Match
  ): zio.aws.codeguruprofiler.model.Match.ReadOnly = new Wrapper(impl)
}
