package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codeguruprofiler.model.primitives.{
  RevisionId,
  ProfilingGroupName
}
import scala.jdk.CollectionConverters._
final case class RemovePermissionRequest(
    actionGroup: zio.aws.codeguruprofiler.model.ActionGroup,
    profilingGroupName: ProfilingGroupName,
    revisionId: RevisionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.RemovePermissionRequest = {
    import RemovePermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.RemovePermissionRequest
      .builder()
      .actionGroup(actionGroup.unwrap)
      .profilingGroupName(
        ProfilingGroupName.unwrap(profilingGroupName): java.lang.String
      )
      .revisionId(RevisionId.unwrap(revisionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.RemovePermissionRequest.ReadOnly =
    zio.aws.codeguruprofiler.model.RemovePermissionRequest.wrap(buildAwsValue())
}
object RemovePermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.RemovePermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.RemovePermissionRequest =
      zio.aws.codeguruprofiler.model
        .RemovePermissionRequest(actionGroup, profilingGroupName, revisionId)
    def actionGroup: zio.aws.codeguruprofiler.model.ActionGroup
    def profilingGroupName: ProfilingGroupName
    def revisionId: RevisionId
    def getActionGroup
        : ZIO[Any, Nothing, zio.aws.codeguruprofiler.model.ActionGroup] =
      ZIO.succeed(actionGroup)
    def getProfilingGroupName: ZIO[Any, Nothing, ProfilingGroupName] =
      ZIO.succeed(profilingGroupName)
    def getRevisionId: ZIO[Any, Nothing, RevisionId] = ZIO.succeed(revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.RemovePermissionRequest
  ) extends zio.aws.codeguruprofiler.model.RemovePermissionRequest.ReadOnly {
    override val actionGroup: zio.aws.codeguruprofiler.model.ActionGroup =
      zio.aws.codeguruprofiler.model.ActionGroup.wrap(impl.actionGroup())
    override val profilingGroupName: ProfilingGroupName =
      zio.aws.codeguruprofiler.model.primitives
        .ProfilingGroupName(impl.profilingGroupName())
    override val revisionId: RevisionId =
      zio.aws.codeguruprofiler.model.primitives.RevisionId(impl.revisionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.RemovePermissionRequest
  ): zio.aws.codeguruprofiler.model.RemovePermissionRequest.ReadOnly =
    new Wrapper(impl)
}
