package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class FrameMetric(
    frameName: String,
    threadStates: Iterable[String],
    `type`: zio.aws.codeguruprofiler.model.MetricType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.FrameMetric = {
    import FrameMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.FrameMetric
      .builder()
      .frameName(frameName: java.lang.String)
      .threadStates(threadStates.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.codeguruprofiler.model.FrameMetric.ReadOnly =
    zio.aws.codeguruprofiler.model.FrameMetric.wrap(buildAwsValue())
}
object FrameMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.FrameMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.FrameMetric =
      zio.aws.codeguruprofiler.model
        .FrameMetric(frameName, threadStates, `type`)
    def frameName: String
    def threadStates: List[String]
    def `type`: zio.aws.codeguruprofiler.model.MetricType
    def getFrameName: ZIO[Any, Nothing, String] = ZIO.succeed(frameName)
    def getThreadStates: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(threadStates)
    def getType: ZIO[Any, Nothing, zio.aws.codeguruprofiler.model.MetricType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.FrameMetric
  ) extends zio.aws.codeguruprofiler.model.FrameMetric.ReadOnly {
    override val frameName: String = impl.frameName(): String
    override val threadStates: List[String] = impl
      .threadStates()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val `type`: zio.aws.codeguruprofiler.model.MetricType =
      zio.aws.codeguruprofiler.model.MetricType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.FrameMetric
  ): zio.aws.codeguruprofiler.model.FrameMetric.ReadOnly = new Wrapper(impl)
}
