package zio.aws.codeguruprofiler.model
import scala.jdk.CollectionConverters._
sealed trait EventPublisher {
  def unwrap
      : software.amazon.awssdk.services.codeguruprofiler.model.EventPublisher
}
object EventPublisher {
  def wrap(
      value: software.amazon.awssdk.services.codeguruprofiler.model.EventPublisher
  ): zio.aws.codeguruprofiler.model.EventPublisher = value match {
    case software.amazon.awssdk.services.codeguruprofiler.model.EventPublisher.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codeguruprofiler.model.EventPublisher.ANOMALY_DETECTION =>
      val r = AnomalyDetection
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codeguruprofiler.model.EventPublisher {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.EventPublisher =
      software.amazon.awssdk.services.codeguruprofiler.model.EventPublisher.UNKNOWN_TO_SDK_VERSION
  }
  case object AnomalyDetection
      extends zio.aws.codeguruprofiler.model.EventPublisher {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.EventPublisher =
      software.amazon.awssdk.services.codeguruprofiler.model.EventPublisher.ANOMALY_DETECTION
  }
}
