package zio.aws.codeguruprofiler.model
import scala.jdk.CollectionConverters._
sealed trait MetricType {
  def unwrap: software.amazon.awssdk.services.codeguruprofiler.model.MetricType
}
object MetricType {
  def wrap(
      value: software.amazon.awssdk.services.codeguruprofiler.model.MetricType
  ): zio.aws.codeguruprofiler.model.MetricType = value match {
    case software.amazon.awssdk.services.codeguruprofiler.model.MetricType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codeguruprofiler.model.MetricType.AGGREGATED_RELATIVE_TOTAL_TIME =>
      val r = AggregatedRelativeTotalTime
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codeguruprofiler.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.MetricType =
      software.amazon.awssdk.services.codeguruprofiler.model.MetricType.UNKNOWN_TO_SDK_VERSION
  }
  case object AggregatedRelativeTotalTime
      extends zio.aws.codeguruprofiler.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.codeguruprofiler.model.MetricType =
      software.amazon.awssdk.services.codeguruprofiler.model.MetricType.AGGREGATED_RELATIVE_TOTAL_TIME
  }
}
