package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeguruprofiler.model.primitives.{
  ProfilingGroupName,
  AnomalyInstanceId
}
import scala.jdk.CollectionConverters._
final case class SubmitFeedbackRequest(
    anomalyInstanceId: AnomalyInstanceId,
    comment: Optional[String] = Optional.Absent,
    profilingGroupName: ProfilingGroupName,
    `type`: zio.aws.codeguruprofiler.model.FeedbackType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.SubmitFeedbackRequest = {
    import SubmitFeedbackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.SubmitFeedbackRequest
      .builder()
      .anomalyInstanceId(
        AnomalyInstanceId.unwrap(anomalyInstanceId): java.lang.String
      )
      .optionallyWith(comment.map(value => value: java.lang.String))(_.comment)
      .profilingGroupName(
        ProfilingGroupName.unwrap(profilingGroupName): java.lang.String
      )
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.SubmitFeedbackRequest.ReadOnly =
    zio.aws.codeguruprofiler.model.SubmitFeedbackRequest.wrap(buildAwsValue())
}
object SubmitFeedbackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.SubmitFeedbackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.SubmitFeedbackRequest =
      zio.aws.codeguruprofiler.model.SubmitFeedbackRequest(
        anomalyInstanceId,
        comment.map(value => value),
        profilingGroupName,
        `type`
      )
    def anomalyInstanceId: AnomalyInstanceId
    def comment: Optional[String]
    def profilingGroupName: ProfilingGroupName
    def `type`: zio.aws.codeguruprofiler.model.FeedbackType
    def getAnomalyInstanceId: ZIO[Any, Nothing, AnomalyInstanceId] =
      ZIO.succeed(anomalyInstanceId)
    def getComment: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("comment", comment)
    def getProfilingGroupName: ZIO[Any, Nothing, ProfilingGroupName] =
      ZIO.succeed(profilingGroupName)
    def getType
        : ZIO[Any, Nothing, zio.aws.codeguruprofiler.model.FeedbackType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.SubmitFeedbackRequest
  ) extends zio.aws.codeguruprofiler.model.SubmitFeedbackRequest.ReadOnly {
    override val anomalyInstanceId: AnomalyInstanceId =
      zio.aws.codeguruprofiler.model.primitives
        .AnomalyInstanceId(impl.anomalyInstanceId())
    override val comment: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value => value: String)
    override val profilingGroupName: ProfilingGroupName =
      zio.aws.codeguruprofiler.model.primitives
        .ProfilingGroupName(impl.profilingGroupName())
    override val `type`: zio.aws.codeguruprofiler.model.FeedbackType =
      zio.aws.codeguruprofiler.model.FeedbackType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.SubmitFeedbackRequest
  ): zio.aws.codeguruprofiler.model.SubmitFeedbackRequest.ReadOnly =
    new Wrapper(impl)
}
