package zio.aws.codeguruprofiler.model
import zio.aws.codeguruprofiler.model.primitives.Timestamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ProfilingStatus(
    latestAgentOrchestratedAt: Optional[Timestamp] = Optional.Absent,
    latestAgentProfileReportedAt: Optional[Timestamp] = Optional.Absent,
    latestAggregatedProfile: Optional[
      zio.aws.codeguruprofiler.model.AggregatedProfileTime
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.ProfilingStatus = {
    import ProfilingStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.ProfilingStatus
      .builder()
      .optionallyWith(
        latestAgentOrchestratedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.latestAgentOrchestratedAt)
      .optionallyWith(
        latestAgentProfileReportedAt.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.latestAgentProfileReportedAt)
      .optionallyWith(
        latestAggregatedProfile.map(value => value.buildAwsValue())
      )(_.latestAggregatedProfile)
      .build()
  }
  def asReadOnly: zio.aws.codeguruprofiler.model.ProfilingStatus.ReadOnly =
    zio.aws.codeguruprofiler.model.ProfilingStatus.wrap(buildAwsValue())
}
object ProfilingStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.ProfilingStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.ProfilingStatus =
      zio.aws.codeguruprofiler.model.ProfilingStatus(
        latestAgentOrchestratedAt.map(value => value),
        latestAgentProfileReportedAt.map(value => value),
        latestAggregatedProfile.map(value => value.asEditable)
      )
    def latestAgentOrchestratedAt: Optional[Timestamp]
    def latestAgentProfileReportedAt: Optional[Timestamp]
    def latestAggregatedProfile: Optional[
      zio.aws.codeguruprofiler.model.AggregatedProfileTime.ReadOnly
    ]
    def getLatestAgentOrchestratedAt: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("latestAgentOrchestratedAt", latestAgentOrchestratedAt)
    def getLatestAgentProfileReportedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "latestAgentProfileReportedAt",
        latestAgentProfileReportedAt
      )
    def getLatestAggregatedProfile: ZIO[
      Any,
      AwsError,
      zio.aws.codeguruprofiler.model.AggregatedProfileTime.ReadOnly
    ] = AwsError.unwrapOptionField(
      "latestAggregatedProfile",
      latestAggregatedProfile
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ProfilingStatus
  ) extends zio.aws.codeguruprofiler.model.ProfilingStatus.ReadOnly {
    override val latestAgentOrchestratedAt: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestAgentOrchestratedAt())
        .map(value =>
          zio.aws.codeguruprofiler.model.primitives.Timestamp(value)
        )
    override val latestAgentProfileReportedAt: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestAgentProfileReportedAt())
        .map(value =>
          zio.aws.codeguruprofiler.model.primitives.Timestamp(value)
        )
    override val latestAggregatedProfile: Optional[
      zio.aws.codeguruprofiler.model.AggregatedProfileTime.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.latestAggregatedProfile())
      .map(value =>
        zio.aws.codeguruprofiler.model.AggregatedProfileTime.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ProfilingStatus
  ): zio.aws.codeguruprofiler.model.ProfilingStatus.ReadOnly = new Wrapper(impl)
}
