package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codeguruprofiler.model.primitives.ProfilingGroupName
import scala.jdk.CollectionConverters._
final case class DeleteProfilingGroupRequest(
    profilingGroupName: ProfilingGroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.DeleteProfilingGroupRequest = {
    import DeleteProfilingGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.DeleteProfilingGroupRequest
      .builder()
      .profilingGroupName(
        ProfilingGroupName.unwrap(profilingGroupName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.DeleteProfilingGroupRequest.ReadOnly =
    zio.aws.codeguruprofiler.model.DeleteProfilingGroupRequest
      .wrap(buildAwsValue())
}
object DeleteProfilingGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.DeleteProfilingGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.DeleteProfilingGroupRequest =
      zio.aws.codeguruprofiler.model
        .DeleteProfilingGroupRequest(profilingGroupName)
    def profilingGroupName: ProfilingGroupName
    def getProfilingGroupName: ZIO[Any, Nothing, ProfilingGroupName] =
      ZIO.succeed(profilingGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.DeleteProfilingGroupRequest
  ) extends zio.aws.codeguruprofiler.model.DeleteProfilingGroupRequest.ReadOnly {
    override val profilingGroupName: ProfilingGroupName =
      zio.aws.codeguruprofiler.model.primitives
        .ProfilingGroupName(impl.profilingGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.DeleteProfilingGroupRequest
  ): zio.aws.codeguruprofiler.model.DeleteProfilingGroupRequest.ReadOnly =
    new Wrapper(impl)
}
