package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codeguruprofiler.model.primitives.RevisionId
import scala.jdk.CollectionConverters._
final case class PutPermissionResponse(policy: String, revisionId: RevisionId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.PutPermissionResponse = {
    import PutPermissionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.PutPermissionResponse
      .builder()
      .policy(policy: java.lang.String)
      .revisionId(RevisionId.unwrap(revisionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.PutPermissionResponse.ReadOnly =
    zio.aws.codeguruprofiler.model.PutPermissionResponse.wrap(buildAwsValue())
}
object PutPermissionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.PutPermissionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.PutPermissionResponse =
      zio.aws.codeguruprofiler.model.PutPermissionResponse(policy, revisionId)
    def policy: String
    def revisionId: RevisionId
    def getPolicy: ZIO[Any, Nothing, String] = ZIO.succeed(policy)
    def getRevisionId: ZIO[Any, Nothing, RevisionId] = ZIO.succeed(revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.PutPermissionResponse
  ) extends zio.aws.codeguruprofiler.model.PutPermissionResponse.ReadOnly {
    override val policy: String = impl.policy(): String
    override val revisionId: RevisionId =
      zio.aws.codeguruprofiler.model.primitives.RevisionId(impl.revisionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.PutPermissionResponse
  ): zio.aws.codeguruprofiler.model.PutPermissionResponse.ReadOnly =
    new Wrapper(impl)
}
