package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.codeguruprofiler.model.primitives.{ProfilingGroupName, Timestamp}
import scala.jdk.CollectionConverters._
final case class GetRecommendationsResponse(
    anomalies: Iterable[zio.aws.codeguruprofiler.model.Anomaly],
    profileEndTime: Timestamp,
    profileStartTime: Timestamp,
    profilingGroupName: ProfilingGroupName,
    recommendations: Iterable[zio.aws.codeguruprofiler.model.Recommendation]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.GetRecommendationsResponse = {
    import GetRecommendationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.GetRecommendationsResponse
      .builder()
      .anomalies(anomalies.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .profileEndTime(Timestamp.unwrap(profileEndTime): Instant)
      .profileStartTime(Timestamp.unwrap(profileStartTime): Instant)
      .profilingGroupName(
        ProfilingGroupName.unwrap(profilingGroupName): java.lang.String
      )
      .recommendations(recommendations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.GetRecommendationsResponse.ReadOnly =
    zio.aws.codeguruprofiler.model.GetRecommendationsResponse
      .wrap(buildAwsValue())
}
object GetRecommendationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.GetRecommendationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.GetRecommendationsResponse =
      zio.aws.codeguruprofiler.model.GetRecommendationsResponse(
        anomalies.map { item =>
          item.asEditable
        },
        profileEndTime,
        profileStartTime,
        profilingGroupName,
        recommendations.map { item =>
          item.asEditable
        }
      )
    def anomalies: List[zio.aws.codeguruprofiler.model.Anomaly.ReadOnly]
    def profileEndTime: Timestamp
    def profileStartTime: Timestamp
    def profilingGroupName: ProfilingGroupName
    def recommendations
        : List[zio.aws.codeguruprofiler.model.Recommendation.ReadOnly]
    def getAnomalies: ZIO[Any, Nothing, List[
      zio.aws.codeguruprofiler.model.Anomaly.ReadOnly
    ]] = ZIO.succeed(anomalies)
    def getProfileEndTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(profileEndTime)
    def getProfileStartTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(profileStartTime)
    def getProfilingGroupName: ZIO[Any, Nothing, ProfilingGroupName] =
      ZIO.succeed(profilingGroupName)
    def getRecommendations: ZIO[Any, Nothing, List[
      zio.aws.codeguruprofiler.model.Recommendation.ReadOnly
    ]] = ZIO.succeed(recommendations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.GetRecommendationsResponse
  ) extends zio.aws.codeguruprofiler.model.GetRecommendationsResponse.ReadOnly {
    override val anomalies
        : List[zio.aws.codeguruprofiler.model.Anomaly.ReadOnly] = impl
      .anomalies()
      .asScala
      .map { item =>
        zio.aws.codeguruprofiler.model.Anomaly.wrap(item)
      }
      .toList
    override val profileEndTime: Timestamp =
      zio.aws.codeguruprofiler.model.primitives.Timestamp(impl.profileEndTime())
    override val profileStartTime: Timestamp =
      zio.aws.codeguruprofiler.model.primitives
        .Timestamp(impl.profileStartTime())
    override val profilingGroupName: ProfilingGroupName =
      zio.aws.codeguruprofiler.model.primitives
        .ProfilingGroupName(impl.profilingGroupName())
    override val recommendations
        : List[zio.aws.codeguruprofiler.model.Recommendation.ReadOnly] = impl
      .recommendations()
      .asScala
      .map { item =>
        zio.aws.codeguruprofiler.model.Recommendation.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.GetRecommendationsResponse
  ): zio.aws.codeguruprofiler.model.GetRecommendationsResponse.ReadOnly =
    new Wrapper(impl)
}
