package zio.aws.codeguruprofiler
import zio.aws.codeguruprofiler.model.ProfileTime.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.codeguruprofiler.model.{
  GetProfileRequest,
  ListFindingsReportsRequest,
  GetFindingsReportAccountSummaryRequest,
  ConfigureAgentRequest,
  ListProfileTimesRequest,
  ListProfilingGroupsRequest,
  BatchGetFrameMetricDataRequest,
  PutPermissionRequest,
  ListTagsForResourceRequest,
  GetRecommendationsRequest,
  CreateProfilingGroupRequest,
  AddNotificationChannelsRequest,
  DeleteProfilingGroupRequest,
  PostAgentProfileRequest,
  GetNotificationConfigurationRequest,
  GetPolicyRequest,
  UntagResourceRequest,
  UpdateProfilingGroupRequest,
  SubmitFeedbackRequest,
  DescribeProfilingGroupRequest,
  RemovePermissionRequest,
  TagResourceRequest,
  RemoveNotificationChannelRequest
}
import zio.aws.core.AwsError
import software.amazon.awssdk.services.codeguruprofiler.CodeGuruProfilerAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object CodeGuruProfilerMock extends Mock[CodeGuruProfiler] {
  object ListProfilingGroups
      extends Effect[
        ListProfilingGroupsRequest,
        AwsError,
        zio.aws.codeguruprofiler.model.ListProfilingGroupsResponse.ReadOnly
      ]
  object CreateProfilingGroup
      extends Effect[
        CreateProfilingGroupRequest,
        AwsError,
        zio.aws.codeguruprofiler.model.CreateProfilingGroupResponse.ReadOnly
      ]
  object PutPermission
      extends Effect[
        PutPermissionRequest,
        AwsError,
        zio.aws.codeguruprofiler.model.PutPermissionResponse.ReadOnly
      ]
  object ConfigureAgent
      extends Effect[
        ConfigureAgentRequest,
        AwsError,
        zio.aws.codeguruprofiler.model.ConfigureAgentResponse.ReadOnly
      ]
  object ListFindingsReports
      extends Effect[
        ListFindingsReportsRequest,
        AwsError,
        zio.aws.codeguruprofiler.model.ListFindingsReportsResponse.ReadOnly
      ]
  object AddNotificationChannels
      extends Effect[
        AddNotificationChannelsRequest,
        AwsError,
        zio.aws.codeguruprofiler.model.AddNotificationChannelsResponse.ReadOnly
      ]
  object GetRecommendations
      extends Effect[
        GetRecommendationsRequest,
        AwsError,
        zio.aws.codeguruprofiler.model.GetRecommendationsResponse.ReadOnly
      ]
  object DescribeProfilingGroup
      extends Effect[
        DescribeProfilingGroupRequest,
        AwsError,
        zio.aws.codeguruprofiler.model.DescribeProfilingGroupResponse.ReadOnly
      ]
  object PostAgentProfile
      extends Effect[
        PostAgentProfileRequest,
        AwsError,
        zio.aws.codeguruprofiler.model.PostAgentProfileResponse.ReadOnly
      ]
  object SubmitFeedback
      extends Effect[
        SubmitFeedbackRequest,
        AwsError,
        zio.aws.codeguruprofiler.model.SubmitFeedbackResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.codeguruprofiler.model.UntagResourceResponse.ReadOnly
      ]
  object DeleteProfilingGroup
      extends Effect[
        DeleteProfilingGroupRequest,
        AwsError,
        zio.aws.codeguruprofiler.model.DeleteProfilingGroupResponse.ReadOnly
      ]
  object GetProfile
      extends Effect[
        GetProfileRequest,
        AwsError,
        zio.aws.codeguruprofiler.model.GetProfileResponse.ReadOnly
      ]
  object RemovePermission
      extends Effect[
        RemovePermissionRequest,
        AwsError,
        zio.aws.codeguruprofiler.model.RemovePermissionResponse.ReadOnly
      ]
  object RemoveNotificationChannel
      extends Effect[
        RemoveNotificationChannelRequest,
        AwsError,
        zio.aws.codeguruprofiler.model.RemoveNotificationChannelResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.codeguruprofiler.model.ListTagsForResourceResponse.ReadOnly
      ]
  object ListProfileTimes
      extends Stream[ListProfileTimesRequest, AwsError, ReadOnly]
  object ListProfileTimesPaginated
      extends Effect[
        ListProfileTimesRequest,
        AwsError,
        zio.aws.codeguruprofiler.model.ListProfileTimesResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.codeguruprofiler.model.TagResourceResponse.ReadOnly
      ]
  object BatchGetFrameMetricData
      extends Effect[
        BatchGetFrameMetricDataRequest,
        AwsError,
        zio.aws.codeguruprofiler.model.BatchGetFrameMetricDataResponse.ReadOnly
      ]
  object GetPolicy
      extends Effect[
        GetPolicyRequest,
        AwsError,
        zio.aws.codeguruprofiler.model.GetPolicyResponse.ReadOnly
      ]
  object UpdateProfilingGroup
      extends Effect[
        UpdateProfilingGroupRequest,
        AwsError,
        zio.aws.codeguruprofiler.model.UpdateProfilingGroupResponse.ReadOnly
      ]
  object GetNotificationConfiguration
      extends Effect[
        GetNotificationConfigurationRequest,
        AwsError,
        zio.aws.codeguruprofiler.model.GetNotificationConfigurationResponse.ReadOnly
      ]
  object GetFindingsReportAccountSummary
      extends Effect[
        GetFindingsReportAccountSummaryRequest,
        AwsError,
        zio.aws.codeguruprofiler.model.GetFindingsReportAccountSummaryResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, CodeGuruProfiler] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new CodeGuruProfiler {
          val api: CodeGuruProfilerAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : CodeGuruProfiler = this
          def listProfilingGroups(request: ListProfilingGroupsRequest): IO[
            AwsError,
            zio.aws.codeguruprofiler.model.ListProfilingGroupsResponse.ReadOnly
          ] = proxy(ListProfilingGroups, request)
          def createProfilingGroup(request: CreateProfilingGroupRequest): IO[
            AwsError,
            zio.aws.codeguruprofiler.model.CreateProfilingGroupResponse.ReadOnly
          ] = proxy(CreateProfilingGroup, request)
          def putPermission(request: PutPermissionRequest): IO[
            AwsError,
            zio.aws.codeguruprofiler.model.PutPermissionResponse.ReadOnly
          ] = proxy(PutPermission, request)
          def configureAgent(request: ConfigureAgentRequest): IO[
            AwsError,
            zio.aws.codeguruprofiler.model.ConfigureAgentResponse.ReadOnly
          ] = proxy(ConfigureAgent, request)
          def listFindingsReports(request: ListFindingsReportsRequest): IO[
            AwsError,
            zio.aws.codeguruprofiler.model.ListFindingsReportsResponse.ReadOnly
          ] = proxy(ListFindingsReports, request)
          def addNotificationChannels(
              request: AddNotificationChannelsRequest
          ): IO[
            AwsError,
            zio.aws.codeguruprofiler.model.AddNotificationChannelsResponse.ReadOnly
          ] = proxy(AddNotificationChannels, request)
          def getRecommendations(request: GetRecommendationsRequest): IO[
            AwsError,
            zio.aws.codeguruprofiler.model.GetRecommendationsResponse.ReadOnly
          ] = proxy(GetRecommendations, request)
          def describeProfilingGroup(
              request: DescribeProfilingGroupRequest
          ): IO[
            AwsError,
            zio.aws.codeguruprofiler.model.DescribeProfilingGroupResponse.ReadOnly
          ] = proxy(DescribeProfilingGroup, request)
          def postAgentProfile(request: PostAgentProfileRequest): IO[
            AwsError,
            zio.aws.codeguruprofiler.model.PostAgentProfileResponse.ReadOnly
          ] = proxy(PostAgentProfile, request)
          def submitFeedback(request: SubmitFeedbackRequest): IO[
            AwsError,
            zio.aws.codeguruprofiler.model.SubmitFeedbackResponse.ReadOnly
          ] = proxy(SubmitFeedback, request)
          def untagResource(request: UntagResourceRequest): IO[
            AwsError,
            zio.aws.codeguruprofiler.model.UntagResourceResponse.ReadOnly
          ] = proxy(UntagResource, request)
          def deleteProfilingGroup(request: DeleteProfilingGroupRequest): IO[
            AwsError,
            zio.aws.codeguruprofiler.model.DeleteProfilingGroupResponse.ReadOnly
          ] = proxy(DeleteProfilingGroup, request)
          def getProfile(request: GetProfileRequest): IO[
            AwsError,
            zio.aws.codeguruprofiler.model.GetProfileResponse.ReadOnly
          ] = proxy(GetProfile, request)
          def removePermission(request: RemovePermissionRequest): IO[
            AwsError,
            zio.aws.codeguruprofiler.model.RemovePermissionResponse.ReadOnly
          ] = proxy(RemovePermission, request)
          def removeNotificationChannel(
              request: RemoveNotificationChannelRequest
          ): IO[
            AwsError,
            zio.aws.codeguruprofiler.model.RemoveNotificationChannelResponse.ReadOnly
          ] = proxy(RemoveNotificationChannel, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.codeguruprofiler.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def listProfileTimes(
              request: ListProfileTimesRequest
          ): ZStream[Any, AwsError, ReadOnly] =
            rts.unsafeRun(proxy(ListProfileTimes, request))
          def listProfileTimesPaginated(request: ListProfileTimesRequest): IO[
            AwsError,
            zio.aws.codeguruprofiler.model.ListProfileTimesResponse.ReadOnly
          ] = proxy(ListProfileTimesPaginated, request)
          def tagResource(request: TagResourceRequest): IO[
            AwsError,
            zio.aws.codeguruprofiler.model.TagResourceResponse.ReadOnly
          ] = proxy(TagResource, request)
          def batchGetFrameMetricData(
              request: BatchGetFrameMetricDataRequest
          ): IO[
            AwsError,
            zio.aws.codeguruprofiler.model.BatchGetFrameMetricDataResponse.ReadOnly
          ] = proxy(BatchGetFrameMetricData, request)
          def getPolicy(request: GetPolicyRequest): IO[
            AwsError,
            zio.aws.codeguruprofiler.model.GetPolicyResponse.ReadOnly
          ] = proxy(GetPolicy, request)
          def updateProfilingGroup(request: UpdateProfilingGroupRequest): IO[
            AwsError,
            zio.aws.codeguruprofiler.model.UpdateProfilingGroupResponse.ReadOnly
          ] = proxy(UpdateProfilingGroup, request)
          def getNotificationConfiguration(
              request: GetNotificationConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.codeguruprofiler.model.GetNotificationConfigurationResponse.ReadOnly
          ] = proxy(GetNotificationConfiguration, request)
          def getFindingsReportAccountSummary(
              request: GetFindingsReportAccountSummaryRequest
          ): IO[
            AwsError,
            zio.aws.codeguruprofiler.model.GetFindingsReportAccountSummaryResponse.ReadOnly
          ] = proxy(GetFindingsReportAccountSummary, request)
        }
      }
    }
    .toLayer
}
