package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.codeguruprofiler.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class ProfileTime(start: Option[Timestamp] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.ProfileTime = {
    import ProfileTime.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.ProfileTime
      .builder()
      .optionallyWith(start.map(value => Timestamp.unwrap(value): Instant))(
        _.start
      )
      .build()
  }
  def asReadOnly: zio.aws.codeguruprofiler.model.ProfileTime.ReadOnly =
    zio.aws.codeguruprofiler.model.ProfileTime.wrap(buildAwsValue())
}
object ProfileTime {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.ProfileTime
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.ProfileTime =
      zio.aws.codeguruprofiler.model.ProfileTime(start.map(value => value))
    def start: Option[Timestamp]
    def getStart: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("start", start)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ProfileTime
  ) extends zio.aws.codeguruprofiler.model.ProfileTime.ReadOnly {
    override val start: Option[Timestamp] = scala
      .Option(impl.start())
      .map(value => zio.aws.codeguruprofiler.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ProfileTime
  ): zio.aws.codeguruprofiler.model.ProfileTime.ReadOnly = new Wrapper(impl)
}
