package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ConfigureAgentResponse(
    configuration: zio.aws.codeguruprofiler.model.AgentConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.ConfigureAgentResponse = {
    import ConfigureAgentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.ConfigureAgentResponse
      .builder()
      .configuration(configuration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.ConfigureAgentResponse.ReadOnly =
    zio.aws.codeguruprofiler.model.ConfigureAgentResponse.wrap(buildAwsValue())
}
object ConfigureAgentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.ConfigureAgentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.ConfigureAgentResponse =
      zio.aws.codeguruprofiler.model
        .ConfigureAgentResponse(configuration.asEditable)
    def configuration
        : zio.aws.codeguruprofiler.model.AgentConfiguration.ReadOnly
    def getConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.codeguruprofiler.model.AgentConfiguration.ReadOnly
    ] = ZIO.succeed(configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ConfigureAgentResponse
  ) extends zio.aws.codeguruprofiler.model.ConfigureAgentResponse.ReadOnly {
    override val configuration
        : zio.aws.codeguruprofiler.model.AgentConfiguration.ReadOnly =
      zio.aws.codeguruprofiler.model.AgentConfiguration
        .wrap(impl.configuration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ConfigureAgentResponse
  ): zio.aws.codeguruprofiler.model.ConfigureAgentResponse.ReadOnly =
    new Wrapper(impl)
}
