package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NotificationConfiguration(
    channels: Option[Iterable[zio.aws.codeguruprofiler.model.Channel]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.NotificationConfiguration = {
    import NotificationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.NotificationConfiguration
      .builder()
      .optionallyWith(
        channels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.channels)
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.NotificationConfiguration.ReadOnly =
    zio.aws.codeguruprofiler.model.NotificationConfiguration
      .wrap(buildAwsValue())
}
object NotificationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.NotificationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.NotificationConfiguration =
      zio.aws.codeguruprofiler.model.NotificationConfiguration(
        channels.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def channels: Option[List[zio.aws.codeguruprofiler.model.Channel.ReadOnly]]
    def getChannels: ZIO[Any, AwsError, List[
      zio.aws.codeguruprofiler.model.Channel.ReadOnly
    ]] = AwsError.unwrapOptionField("channels", channels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.NotificationConfiguration
  ) extends zio.aws.codeguruprofiler.model.NotificationConfiguration.ReadOnly {
    override val channels
        : Option[List[zio.aws.codeguruprofiler.model.Channel.ReadOnly]] = scala
      .Option(impl.channels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codeguruprofiler.model.Channel.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.NotificationConfiguration
  ): zio.aws.codeguruprofiler.model.NotificationConfiguration.ReadOnly =
    new Wrapper(impl)
}
