package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeguruprofiler.model.primitives.{
  RevisionId,
  ProfilingGroupName,
  Principal
}
import scala.jdk.CollectionConverters._
final case class PutPermissionRequest(
    actionGroup: zio.aws.codeguruprofiler.model.ActionGroup,
    principals: Iterable[Principal],
    profilingGroupName: ProfilingGroupName,
    revisionId: Option[RevisionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.PutPermissionRequest = {
    import PutPermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.PutPermissionRequest
      .builder()
      .actionGroup(actionGroup.unwrap)
      .principals(principals.map { item =>
        Principal.unwrap(item): java.lang.String
      }.asJavaCollection)
      .profilingGroupName(
        ProfilingGroupName.unwrap(profilingGroupName): java.lang.String
      )
      .optionallyWith(
        revisionId.map(value => RevisionId.unwrap(value): java.lang.String)
      )(_.revisionId)
      .build()
  }
  def asReadOnly: zio.aws.codeguruprofiler.model.PutPermissionRequest.ReadOnly =
    zio.aws.codeguruprofiler.model.PutPermissionRequest.wrap(buildAwsValue())
}
object PutPermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.PutPermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.PutPermissionRequest =
      zio.aws.codeguruprofiler.model.PutPermissionRequest(
        actionGroup,
        principals,
        profilingGroupName,
        revisionId.map(value => value)
      )
    def actionGroup: zio.aws.codeguruprofiler.model.ActionGroup
    def principals: List[Principal]
    def profilingGroupName: ProfilingGroupName
    def revisionId: Option[RevisionId]
    def getActionGroup
        : ZIO[Any, Nothing, zio.aws.codeguruprofiler.model.ActionGroup] =
      ZIO.succeed(actionGroup)
    def getPrincipals: ZIO[Any, Nothing, List[Principal]] =
      ZIO.succeed(principals)
    def getProfilingGroupName: ZIO[Any, Nothing, ProfilingGroupName] =
      ZIO.succeed(profilingGroupName)
    def getRevisionId: ZIO[Any, AwsError, RevisionId] =
      AwsError.unwrapOptionField("revisionId", revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.PutPermissionRequest
  ) extends zio.aws.codeguruprofiler.model.PutPermissionRequest.ReadOnly {
    override val actionGroup: zio.aws.codeguruprofiler.model.ActionGroup =
      zio.aws.codeguruprofiler.model.ActionGroup.wrap(impl.actionGroup())
    override val principals: List[Principal] = impl
      .principals()
      .asScala
      .map { item =>
        zio.aws.codeguruprofiler.model.primitives.Principal(item)
      }
      .toList
    override val profilingGroupName: ProfilingGroupName =
      zio.aws.codeguruprofiler.model.primitives
        .ProfilingGroupName(impl.profilingGroupName())
    override val revisionId: Option[RevisionId] = scala
      .Option(impl.revisionId())
      .map(value => zio.aws.codeguruprofiler.model.primitives.RevisionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.PutPermissionRequest
  ): zio.aws.codeguruprofiler.model.PutPermissionRequest.ReadOnly = new Wrapper(
    impl
  )
}
