package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AddNotificationChannelsResponse(
    notificationConfiguration: Option[
      zio.aws.codeguruprofiler.model.NotificationConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.AddNotificationChannelsResponse = {
    import AddNotificationChannelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.AddNotificationChannelsResponse
      .builder()
      .optionallyWith(
        notificationConfiguration.map(value => value.buildAwsValue())
      )(_.notificationConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.AddNotificationChannelsResponse.ReadOnly =
    zio.aws.codeguruprofiler.model.AddNotificationChannelsResponse
      .wrap(buildAwsValue())
}
object AddNotificationChannelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.AddNotificationChannelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeguruprofiler.model.AddNotificationChannelsResponse =
      zio.aws.codeguruprofiler.model.AddNotificationChannelsResponse(
        notificationConfiguration.map(value => value.asEditable)
      )
    def notificationConfiguration: Option[
      zio.aws.codeguruprofiler.model.NotificationConfiguration.ReadOnly
    ]
    def getNotificationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.codeguruprofiler.model.NotificationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "notificationConfiguration",
      notificationConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.AddNotificationChannelsResponse
  ) extends zio.aws.codeguruprofiler.model.AddNotificationChannelsResponse.ReadOnly {
    override val notificationConfiguration: Option[
      zio.aws.codeguruprofiler.model.NotificationConfiguration.ReadOnly
    ] = scala
      .Option(impl.notificationConfiguration())
      .map(value =>
        zio.aws.codeguruprofiler.model.NotificationConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.AddNotificationChannelsResponse
  ): zio.aws.codeguruprofiler.model.AddNotificationChannelsResponse.ReadOnly =
    new Wrapper(impl)
}
