package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeguruprofiler.model.primitives.{
  ProfilingGroupName,
  ClientToken
}
import scala.jdk.CollectionConverters._
final case class CreateProfilingGroupRequest(
    agentOrchestrationConfig: Option[
      zio.aws.codeguruprofiler.model.AgentOrchestrationConfig
    ] = None,
    clientToken: ClientToken,
    computePlatform: Option[zio.aws.codeguruprofiler.model.ComputePlatform] =
      None,
    profilingGroupName: ProfilingGroupName,
    tags: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.CreateProfilingGroupRequest = {
    import CreateProfilingGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.CreateProfilingGroupRequest
      .builder()
      .optionallyWith(
        agentOrchestrationConfig.map(value => value.buildAwsValue())
      )(_.agentOrchestrationConfig)
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .optionallyWith(computePlatform.map(value => value.unwrap))(
        _.computePlatform
      )
      .profilingGroupName(
        ProfilingGroupName.unwrap(profilingGroupName): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.CreateProfilingGroupRequest.ReadOnly =
    zio.aws.codeguruprofiler.model.CreateProfilingGroupRequest
      .wrap(buildAwsValue())
}
object CreateProfilingGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.CreateProfilingGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.CreateProfilingGroupRequest =
      zio.aws.codeguruprofiler.model.CreateProfilingGroupRequest(
        agentOrchestrationConfig.map(value => value.asEditable),
        clientToken,
        computePlatform.map(value => value),
        profilingGroupName,
        tags.map(value => value)
      )
    def agentOrchestrationConfig: Option[
      zio.aws.codeguruprofiler.model.AgentOrchestrationConfig.ReadOnly
    ]
    def clientToken: ClientToken
    def computePlatform: Option[zio.aws.codeguruprofiler.model.ComputePlatform]
    def profilingGroupName: ProfilingGroupName
    def tags: Option[Map[String, String]]
    def getAgentOrchestrationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.codeguruprofiler.model.AgentOrchestrationConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "agentOrchestrationConfig",
      agentOrchestrationConfig
    )
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
    def getComputePlatform
        : ZIO[Any, AwsError, zio.aws.codeguruprofiler.model.ComputePlatform] =
      AwsError.unwrapOptionField("computePlatform", computePlatform)
    def getProfilingGroupName: ZIO[Any, Nothing, ProfilingGroupName] =
      ZIO.succeed(profilingGroupName)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.CreateProfilingGroupRequest
  ) extends zio.aws.codeguruprofiler.model.CreateProfilingGroupRequest.ReadOnly {
    override val agentOrchestrationConfig: Option[
      zio.aws.codeguruprofiler.model.AgentOrchestrationConfig.ReadOnly
    ] = scala
      .Option(impl.agentOrchestrationConfig())
      .map(value =>
        zio.aws.codeguruprofiler.model.AgentOrchestrationConfig.wrap(value)
      )
    override val clientToken: ClientToken =
      zio.aws.codeguruprofiler.model.primitives.ClientToken(impl.clientToken())
    override val computePlatform
        : Option[zio.aws.codeguruprofiler.model.ComputePlatform] = scala
      .Option(impl.computePlatform())
      .map(value => zio.aws.codeguruprofiler.model.ComputePlatform.wrap(value))
    override val profilingGroupName: ProfilingGroupName =
      zio.aws.codeguruprofiler.model.primitives
        .ProfilingGroupName(impl.profilingGroupName())
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.CreateProfilingGroupRequest
  ): zio.aws.codeguruprofiler.model.CreateProfilingGroupRequest.ReadOnly =
    new Wrapper(impl)
}
