package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.codeguruprofiler.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class AggregatedProfileTime(
    period: Option[zio.aws.codeguruprofiler.model.AggregationPeriod] = None,
    start: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.AggregatedProfileTime = {
    import AggregatedProfileTime.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.AggregatedProfileTime
      .builder()
      .optionallyWith(period.map(value => value.unwrap))(_.period)
      .optionallyWith(start.map(value => Timestamp.unwrap(value): Instant))(
        _.start
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.AggregatedProfileTime.ReadOnly =
    zio.aws.codeguruprofiler.model.AggregatedProfileTime.wrap(buildAwsValue())
}
object AggregatedProfileTime {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.AggregatedProfileTime
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.AggregatedProfileTime =
      zio.aws.codeguruprofiler.model.AggregatedProfileTime(
        period.map(value => value),
        start.map(value => value)
      )
    def period: Option[zio.aws.codeguruprofiler.model.AggregationPeriod]
    def start: Option[Timestamp]
    def getPeriod
        : ZIO[Any, AwsError, zio.aws.codeguruprofiler.model.AggregationPeriod] =
      AwsError.unwrapOptionField("period", period)
    def getStart: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("start", start)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.AggregatedProfileTime
  ) extends zio.aws.codeguruprofiler.model.AggregatedProfileTime.ReadOnly {
    override val period
        : Option[zio.aws.codeguruprofiler.model.AggregationPeriod] = scala
      .Option(impl.period())
      .map(value =>
        zio.aws.codeguruprofiler.model.AggregationPeriod.wrap(value)
      )
    override val start: Option[Timestamp] = scala
      .Option(impl.start())
      .map(value => zio.aws.codeguruprofiler.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.AggregatedProfileTime
  ): zio.aws.codeguruprofiler.model.AggregatedProfileTime.ReadOnly =
    new Wrapper(impl)
}
