package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeguruprofiler.model.primitives.{
  ProfilingGroupName,
  PaginationToken
}
import scala.jdk.CollectionConverters._
final case class ListProfilingGroupsResponse(
    nextToken: Option[PaginationToken] = None,
    profilingGroupNames: Iterable[ProfilingGroupName],
    profilingGroups: Option[
      Iterable[zio.aws.codeguruprofiler.model.ProfilingGroupDescription]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsResponse = {
    import ListProfilingGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .profilingGroupNames(profilingGroupNames.map { item =>
        ProfilingGroupName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        profilingGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.profilingGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.ListProfilingGroupsResponse.ReadOnly =
    zio.aws.codeguruprofiler.model.ListProfilingGroupsResponse
      .wrap(buildAwsValue())
}
object ListProfilingGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeguruprofiler.model.ListProfilingGroupsResponse =
      zio.aws.codeguruprofiler.model.ListProfilingGroupsResponse(
        nextToken.map(value => value),
        profilingGroupNames,
        profilingGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[PaginationToken]
    def profilingGroupNames: List[ProfilingGroupName]
    def profilingGroups: Option[
      List[zio.aws.codeguruprofiler.model.ProfilingGroupDescription.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getProfilingGroupNames: ZIO[Any, Nothing, List[ProfilingGroupName]] =
      ZIO.succeed(profilingGroupNames)
    def getProfilingGroups: ZIO[Any, AwsError, List[
      zio.aws.codeguruprofiler.model.ProfilingGroupDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("profilingGroups", profilingGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsResponse
  ) extends zio.aws.codeguruprofiler.model.ListProfilingGroupsResponse.ReadOnly {
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.codeguruprofiler.model.primitives.PaginationToken(value)
      )
    override val profilingGroupNames: List[ProfilingGroupName] = impl
      .profilingGroupNames()
      .asScala
      .map { item =>
        zio.aws.codeguruprofiler.model.primitives.ProfilingGroupName(item)
      }
      .toList
    override val profilingGroups: Option[
      List[zio.aws.codeguruprofiler.model.ProfilingGroupDescription.ReadOnly]
    ] = scala
      .Option(impl.profilingGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codeguruprofiler.model.ProfilingGroupDescription.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsResponse
  ): zio.aws.codeguruprofiler.model.ListProfilingGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
