package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.codeguruprofiler.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class BatchGetFrameMetricDataResponse(
    endTime: Timestamp,
    endTimes: Iterable[zio.aws.codeguruprofiler.model.TimestampStructure],
    frameMetricData: Iterable[zio.aws.codeguruprofiler.model.FrameMetricDatum],
    resolution: zio.aws.codeguruprofiler.model.AggregationPeriod,
    startTime: Timestamp,
    unprocessedEndTimes: Map[String, Iterable[
      zio.aws.codeguruprofiler.model.TimestampStructure
    ]]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.BatchGetFrameMetricDataResponse = {
    import BatchGetFrameMetricDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.BatchGetFrameMetricDataResponse
      .builder()
      .endTime(Timestamp.unwrap(endTime): Instant)
      .endTimes(endTimes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .frameMetricData(frameMetricData.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .resolution(resolution.unwrap)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .unprocessedEndTimes(
        unprocessedEndTimes
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.map { item =>
              item.buildAwsValue()
            }.asJavaCollection
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.BatchGetFrameMetricDataResponse.ReadOnly =
    zio.aws.codeguruprofiler.model.BatchGetFrameMetricDataResponse
      .wrap(buildAwsValue())
}
object BatchGetFrameMetricDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.BatchGetFrameMetricDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeguruprofiler.model.BatchGetFrameMetricDataResponse =
      zio.aws.codeguruprofiler.model.BatchGetFrameMetricDataResponse(
        endTime,
        endTimes.map { item =>
          item.asEditable
        },
        frameMetricData.map { item =>
          item.asEditable
        },
        resolution,
        startTime,
        unprocessedEndTimes.map({ case (key, value) =>
          key -> value.map { item =>
            item.asEditable
          }
        })
      )
    def endTime: Timestamp
    def endTimes
        : List[zio.aws.codeguruprofiler.model.TimestampStructure.ReadOnly]
    def frameMetricData
        : List[zio.aws.codeguruprofiler.model.FrameMetricDatum.ReadOnly]
    def resolution: zio.aws.codeguruprofiler.model.AggregationPeriod
    def startTime: Timestamp
    def unprocessedEndTimes: Map[String, List[
      zio.aws.codeguruprofiler.model.TimestampStructure.ReadOnly
    ]]
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getEndTimes: ZIO[Any, Nothing, List[
      zio.aws.codeguruprofiler.model.TimestampStructure.ReadOnly
    ]] = ZIO.succeed(endTimes)
    def getFrameMetricData: ZIO[Any, Nothing, List[
      zio.aws.codeguruprofiler.model.FrameMetricDatum.ReadOnly
    ]] = ZIO.succeed(frameMetricData)
    def getResolution
        : ZIO[Any, Nothing, zio.aws.codeguruprofiler.model.AggregationPeriod] =
      ZIO.succeed(resolution)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getUnprocessedEndTimes: ZIO[Any, Nothing, Map[String, List[
      zio.aws.codeguruprofiler.model.TimestampStructure.ReadOnly
    ]]] = ZIO.succeed(unprocessedEndTimes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.BatchGetFrameMetricDataResponse
  ) extends zio.aws.codeguruprofiler.model.BatchGetFrameMetricDataResponse.ReadOnly {
    override val endTime: Timestamp =
      zio.aws.codeguruprofiler.model.primitives.Timestamp(impl.endTime())
    override val endTimes
        : List[zio.aws.codeguruprofiler.model.TimestampStructure.ReadOnly] =
      impl
        .endTimes()
        .asScala
        .map { item =>
          zio.aws.codeguruprofiler.model.TimestampStructure.wrap(item)
        }
        .toList
    override val frameMetricData
        : List[zio.aws.codeguruprofiler.model.FrameMetricDatum.ReadOnly] = impl
      .frameMetricData()
      .asScala
      .map { item =>
        zio.aws.codeguruprofiler.model.FrameMetricDatum.wrap(item)
      }
      .toList
    override val resolution: zio.aws.codeguruprofiler.model.AggregationPeriod =
      zio.aws.codeguruprofiler.model.AggregationPeriod.wrap(impl.resolution())
    override val startTime: Timestamp =
      zio.aws.codeguruprofiler.model.primitives.Timestamp(impl.startTime())
    override val unprocessedEndTimes: Map[String, List[
      zio.aws.codeguruprofiler.model.TimestampStructure.ReadOnly
    ]] = impl
      .unprocessedEndTimes()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> value.asScala.map { item =>
          zio.aws.codeguruprofiler.model.TimestampStructure.wrap(item)
        }.toList
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.BatchGetFrameMetricDataResponse
  ): zio.aws.codeguruprofiler.model.BatchGetFrameMetricDataResponse.ReadOnly =
    new Wrapper(impl)
}
