package zio.aws.codeguruprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeguruprofiler.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class GetFindingsReportAccountSummaryResponse(
    nextToken: Option[PaginationToken] = None,
    reportSummaries: Iterable[
      zio.aws.codeguruprofiler.model.FindingsReportSummary
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeguruprofiler.model.GetFindingsReportAccountSummaryResponse = {
    import GetFindingsReportAccountSummaryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeguruprofiler.model.GetFindingsReportAccountSummaryResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .reportSummaries(reportSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.codeguruprofiler.model.GetFindingsReportAccountSummaryResponse.ReadOnly =
    zio.aws.codeguruprofiler.model.GetFindingsReportAccountSummaryResponse
      .wrap(buildAwsValue())
}
object GetFindingsReportAccountSummaryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeguruprofiler.model.GetFindingsReportAccountSummaryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeguruprofiler.model.GetFindingsReportAccountSummaryResponse =
      zio.aws.codeguruprofiler.model.GetFindingsReportAccountSummaryResponse(
        nextToken.map(value => value),
        reportSummaries.map { item =>
          item.asEditable
        }
      )
    def nextToken: Option[PaginationToken]
    def reportSummaries
        : List[zio.aws.codeguruprofiler.model.FindingsReportSummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getReportSummaries: ZIO[Any, Nothing, List[
      zio.aws.codeguruprofiler.model.FindingsReportSummary.ReadOnly
    ]] = ZIO.succeed(reportSummaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.GetFindingsReportAccountSummaryResponse
  ) extends zio.aws.codeguruprofiler.model.GetFindingsReportAccountSummaryResponse.ReadOnly {
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.codeguruprofiler.model.primitives.PaginationToken(value)
      )
    override val reportSummaries
        : List[zio.aws.codeguruprofiler.model.FindingsReportSummary.ReadOnly] =
      impl
        .reportSummaries()
        .asScala
        .map { item =>
          zio.aws.codeguruprofiler.model.FindingsReportSummary.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeguruprofiler.model.GetFindingsReportAccountSummaryResponse
  ): zio.aws.codeguruprofiler.model.GetFindingsReportAccountSummaryResponse.ReadOnly =
    new Wrapper(impl)
}
