package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{
  NextToken,
  DeploymentGroupName,
  ApplicationName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDeploymentGroupsResponse(
    applicationName: Optional[ApplicationName] = Optional.Absent,
    deploymentGroups: Optional[Iterable[DeploymentGroupName]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsResponse = {
    import ListDeploymentGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsResponse
      .builder()
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        deploymentGroups.map(value =>
          value.map { item =>
            DeploymentGroupName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.deploymentGroups)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.ListDeploymentGroupsResponse.ReadOnly =
    zio.aws.codedeploy.model.ListDeploymentGroupsResponse.wrap(buildAwsValue())
}
object ListDeploymentGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.ListDeploymentGroupsResponse =
      zio.aws.codedeploy.model.ListDeploymentGroupsResponse(
        applicationName.map(value => value),
        deploymentGroups.map(value => value),
        nextToken.map(value => value)
      )
    def applicationName: Optional[ApplicationName]
    def deploymentGroups: Optional[List[DeploymentGroupName]]
    def nextToken: Optional[NextToken]
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getDeploymentGroups: ZIO[Any, AwsError, List[DeploymentGroupName]] =
      AwsError.unwrapOptionField("deploymentGroups", deploymentGroups)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsResponse
  ) extends zio.aws.codedeploy.model.ListDeploymentGroupsResponse.ReadOnly {
    override val applicationName: Optional[ApplicationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationName())
        .map(value =>
          zio.aws.codedeploy.model.primitives.ApplicationName(value)
        )
    override val deploymentGroups: Optional[List[DeploymentGroupName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.primitives.DeploymentGroupName(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codedeploy.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsResponse
  ): zio.aws.codedeploy.model.ListDeploymentGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
