package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.ApplicationName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateApplicationRequest(
    applicationName: ApplicationName,
    computePlatform: Optional[zio.aws.codedeploy.model.ComputePlatform] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.codedeploy.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.CreateApplicationRequest = {
    import CreateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.CreateApplicationRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .optionallyWith(computePlatform.map(value => value.unwrap))(
        _.computePlatform
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.CreateApplicationRequest.ReadOnly =
    zio.aws.codedeploy.model.CreateApplicationRequest.wrap(buildAwsValue())
}
object CreateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.CreateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.CreateApplicationRequest =
      zio.aws.codedeploy.model.CreateApplicationRequest(
        applicationName,
        computePlatform.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def applicationName: ApplicationName
    def computePlatform: Optional[zio.aws.codedeploy.model.ComputePlatform]
    def tags: Optional[List[zio.aws.codedeploy.model.Tag.ReadOnly]]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getComputePlatform
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.ComputePlatform] =
      AwsError.unwrapOptionField("computePlatform", computePlatform)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.codedeploy.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.CreateApplicationRequest
  ) extends zio.aws.codedeploy.model.CreateApplicationRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.codedeploy.model.primitives
        .ApplicationName(impl.applicationName())
    override val computePlatform
        : Optional[zio.aws.codedeploy.model.ComputePlatform] =
      zio.aws.core.internal
        .optionalFromNullable(impl.computePlatform())
        .map(value => zio.aws.codedeploy.model.ComputePlatform.wrap(value))
    override val tags: Optional[List[zio.aws.codedeploy.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.CreateApplicationRequest
  ): zio.aws.codedeploy.model.CreateApplicationRequest.ReadOnly = new Wrapper(
    impl
  )
}
