package zio.aws.codedeploy.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.codedeploy.model.primitives.{
  Time,
  TrafficWeight,
  DeploymentId,
  CloudFormationResourceType,
  TargetId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CloudFormationTarget(
    deploymentId: Optional[DeploymentId] = Optional.Absent,
    targetId: Optional[TargetId] = Optional.Absent,
    lastUpdatedAt: Optional[Time] = Optional.Absent,
    lifecycleEvents: Optional[
      Iterable[zio.aws.codedeploy.model.LifecycleEvent]
    ] = Optional.Absent,
    status: Optional[zio.aws.codedeploy.model.TargetStatus] = Optional.Absent,
    resourceType: Optional[CloudFormationResourceType] = Optional.Absent,
    targetVersionWeight: Optional[TrafficWeight] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.CloudFormationTarget = {
    import CloudFormationTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.CloudFormationTarget
      .builder()
      .optionallyWith(
        deploymentId.map(value => DeploymentId.unwrap(value): java.lang.String)
      )(_.deploymentId)
      .optionallyWith(
        targetId.map(value => TargetId.unwrap(value): java.lang.String)
      )(_.targetId)
      .optionallyWith(lastUpdatedAt.map(value => Time.unwrap(value): Instant))(
        _.lastUpdatedAt
      )
      .optionallyWith(
        lifecycleEvents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lifecycleEvents)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        resourceType.map(value =>
          CloudFormationResourceType.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(
        targetVersionWeight.map(value =>
          TrafficWeight.unwrap(value): java.lang.Double
        )
      )(_.targetVersionWeight)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.CloudFormationTarget.ReadOnly =
    zio.aws.codedeploy.model.CloudFormationTarget.wrap(buildAwsValue())
}
object CloudFormationTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.CloudFormationTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.CloudFormationTarget =
      zio.aws.codedeploy.model.CloudFormationTarget(
        deploymentId.map(value => value),
        targetId.map(value => value),
        lastUpdatedAt.map(value => value),
        lifecycleEvents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value),
        resourceType.map(value => value),
        targetVersionWeight.map(value => value)
      )
    def deploymentId: Optional[DeploymentId]
    def targetId: Optional[TargetId]
    def lastUpdatedAt: Optional[Time]
    def lifecycleEvents
        : Optional[List[zio.aws.codedeploy.model.LifecycleEvent.ReadOnly]]
    def status: Optional[zio.aws.codedeploy.model.TargetStatus]
    def resourceType: Optional[CloudFormationResourceType]
    def targetVersionWeight: Optional[TrafficWeight]
    def getDeploymentId: ZIO[Any, AwsError, DeploymentId] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getTargetId: ZIO[Any, AwsError, TargetId] =
      AwsError.unwrapOptionField("targetId", targetId)
    def getLastUpdatedAt: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getLifecycleEvents: ZIO[Any, AwsError, List[
      zio.aws.codedeploy.model.LifecycleEvent.ReadOnly
    ]] = AwsError.unwrapOptionField("lifecycleEvents", lifecycleEvents)
    def getStatus: ZIO[Any, AwsError, zio.aws.codedeploy.model.TargetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getResourceType: ZIO[Any, AwsError, CloudFormationResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getTargetVersionWeight: ZIO[Any, AwsError, TrafficWeight] =
      AwsError.unwrapOptionField("targetVersionWeight", targetVersionWeight)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.CloudFormationTarget
  ) extends zio.aws.codedeploy.model.CloudFormationTarget.ReadOnly {
    override val deploymentId: Optional[DeploymentId] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentId())
      .map(value => zio.aws.codedeploy.model.primitives.DeploymentId(value))
    override val targetId: Optional[TargetId] = zio.aws.core.internal
      .optionalFromNullable(impl.targetId())
      .map(value => zio.aws.codedeploy.model.primitives.TargetId(value))
    override val lastUpdatedAt: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.codedeploy.model.primitives.Time(value))
    override val lifecycleEvents
        : Optional[List[zio.aws.codedeploy.model.LifecycleEvent.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycleEvents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.LifecycleEvent.wrap(item)
          }.toList
        )
    override val status: Optional[zio.aws.codedeploy.model.TargetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.codedeploy.model.TargetStatus.wrap(value))
    override val resourceType: Optional[CloudFormationResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.codedeploy.model.primitives.CloudFormationResourceType(value)
        )
    override val targetVersionWeight: Optional[TrafficWeight] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetVersionWeight())
        .map(value => zio.aws.codedeploy.model.primitives.TrafficWeight(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.CloudFormationTarget
  ): zio.aws.codedeploy.model.CloudFormationTarget.ReadOnly = new Wrapper(impl)
}
