package zio.aws.codedeploy
import software.amazon.awssdk.services.codedeploy.paginators.{
  ListApplicationRevisionsPublisher,
  ListDeploymentGroupsPublisher,
  ListDeploymentConfigsPublisher,
  ListDeploymentsPublisher,
  ListApplicationsPublisher
}
import zio.aws.codedeploy.model.ListDeploymentsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.codedeploy.model.{
  StopDeploymentRequest,
  UpdateApplicationRequest,
  BatchGetApplicationRevisionsRequest,
  ListGitHubAccountTokenNamesRequest,
  RegisterOnPremisesInstanceRequest,
  DeleteApplicationRequest,
  DeleteDeploymentConfigRequest,
  BatchGetDeploymentTargetsRequest,
  ListDeploymentTargetsRequest,
  BatchGetApplicationsRequest,
  CreateDeploymentConfigRequest,
  UpdateDeploymentGroupRequest,
  CreateApplicationRequest,
  ListDeploymentGroupsRequest,
  ListTagsForResourceRequest,
  DeleteResourcesByExternalIdRequest,
  DeleteGitHubAccountTokenRequest,
  CreateDeploymentGroupRequest,
  GetApplicationRevisionRequest,
  DeleteDeploymentGroupRequest,
  GetDeploymentGroupRequest,
  ListOnPremisesInstancesRequest,
  ListDeploymentsRequest,
  GetApplicationRequest,
  AddTagsToOnPremisesInstancesRequest,
  ListDeploymentConfigsRequest,
  UntagResourceRequest,
  ListApplicationRevisionsRequest,
  ListApplicationsRequest,
  ContinueDeploymentRequest,
  RegisterApplicationRevisionRequest,
  CreateDeploymentRequest,
  BatchGetOnPremisesInstancesRequest,
  GetDeploymentRequest,
  RemoveTagsFromOnPremisesInstancesRequest,
  GetDeploymentTargetRequest,
  BatchGetDeploymentsRequest,
  BatchGetDeploymentGroupsRequest,
  PutLifecycleEventHookExecutionStatusRequest,
  TagResourceRequest,
  GetOnPremisesInstanceRequest,
  GetDeploymentConfigRequest,
  DeregisterOnPremisesInstanceRequest
}
import zio.aws.codedeploy.model.primitives.{
  ApplicationName,
  DeploymentGroupName,
  DeploymentId,
  DeploymentConfigName
}
import software.amazon.awssdk.services.codedeploy.model.{
  ContinueDeploymentResponse,
  PutLifecycleEventHookExecutionStatusResponse,
  GetApplicationRevisionResponse,
  DeleteDeploymentGroupResponse,
  ListDeploymentConfigsResponse,
  ListOnPremisesInstancesResponse,
  RevisionLocation,
  DeleteDeploymentConfigResponse,
  UpdateApplicationResponse,
  BatchGetDeploymentTargetsResponse,
  Tag,
  ListDeploymentTargetsResponse,
  GetDeploymentGroupResponse,
  ListApplicationRevisionsResponse,
  CreateDeploymentResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  BatchGetDeploymentsResponse,
  DeregisterOnPremisesInstanceResponse,
  BatchGetApplicationRevisionsResponse,
  ListApplicationsResponse,
  GetDeploymentTargetResponse,
  DeleteGitHubAccountTokenResponse,
  CreateDeploymentConfigResponse,
  CreateApplicationResponse,
  ListDeploymentGroupsResponse,
  StopDeploymentResponse,
  ListDeploymentsResponse,
  ListGitHubAccountTokenNamesResponse,
  BatchGetApplicationsResponse,
  CreateDeploymentGroupResponse,
  RegisterOnPremisesInstanceResponse,
  GetDeploymentConfigResponse,
  AddTagsToOnPremisesInstancesResponse,
  UpdateDeploymentGroupResponse,
  BatchGetDeploymentGroupsResponse,
  GetOnPremisesInstanceResponse,
  TagResourceResponse,
  BatchGetOnPremisesInstancesResponse,
  RemoveTagsFromOnPremisesInstancesResponse,
  GetApplicationResponse,
  GetDeploymentResponse,
  DeleteApplicationResponse,
  DeleteResourcesByExternalIdResponse,
  RegisterApplicationRevisionResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.codedeploy.{
  CodeDeployAsyncClientBuilder,
  CodeDeployAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait CodeDeploy extends AspectSupport[CodeDeploy] {
  val api: CodeDeployAsyncClient
  def removeTagsFromOnPremisesInstances(
      request: RemoveTagsFromOnPremisesInstancesRequest
  ): IO[AwsError, Unit]
  def stopDeployment(
      request: StopDeploymentRequest
  ): IO[AwsError, zio.aws.codedeploy.model.StopDeploymentResponse.ReadOnly]
  def getApplication(
      request: GetApplicationRequest
  ): IO[AwsError, zio.aws.codedeploy.model.GetApplicationResponse.ReadOnly]
  def listDeploymentConfigs(
      request: ListDeploymentConfigsRequest
  ): ZStream[Any, AwsError, DeploymentConfigName]
  def listDeploymentConfigsPaginated(request: ListDeploymentConfigsRequest): IO[
    AwsError,
    zio.aws.codedeploy.model.ListDeploymentConfigsResponse.ReadOnly
  ]
  def deleteApplication(request: DeleteApplicationRequest): IO[AwsError, Unit]
  def listOnPremisesInstances(request: ListOnPremisesInstancesRequest): IO[
    AwsError,
    zio.aws.codedeploy.model.ListOnPremisesInstancesResponse.ReadOnly
  ]
  def continueDeployment(request: ContinueDeploymentRequest): IO[AwsError, Unit]
  def updateDeploymentGroup(request: UpdateDeploymentGroupRequest): IO[
    AwsError,
    zio.aws.codedeploy.model.UpdateDeploymentGroupResponse.ReadOnly
  ]
  def deleteResourcesByExternalId(
      request: DeleteResourcesByExternalIdRequest
  ): IO[
    AwsError,
    zio.aws.codedeploy.model.DeleteResourcesByExternalIdResponse.ReadOnly
  ]
  def listGitHubAccountTokenNames(
      request: ListGitHubAccountTokenNamesRequest
  ): IO[
    AwsError,
    zio.aws.codedeploy.model.ListGitHubAccountTokenNamesResponse.ReadOnly
  ]
  def getDeployment(
      request: GetDeploymentRequest
  ): IO[AwsError, zio.aws.codedeploy.model.GetDeploymentResponse.ReadOnly]
  def createDeploymentConfig(request: CreateDeploymentConfigRequest): IO[
    AwsError,
    zio.aws.codedeploy.model.CreateDeploymentConfigResponse.ReadOnly
  ]
  def createApplication(
      request: CreateApplicationRequest
  ): IO[AwsError, zio.aws.codedeploy.model.CreateApplicationResponse.ReadOnly]
  def listApplicationRevisions(
      request: ListApplicationRevisionsRequest
  ): ZStream[Any, AwsError, zio.aws.codedeploy.model.RevisionLocation.ReadOnly]
  def listApplicationRevisionsPaginated(
      request: ListApplicationRevisionsRequest
  ): IO[
    AwsError,
    zio.aws.codedeploy.model.ListApplicationRevisionsResponse.ReadOnly
  ]
  def registerOnPremisesInstance(
      request: RegisterOnPremisesInstanceRequest
  ): IO[AwsError, Unit]
  def deleteDeploymentConfig(
      request: DeleteDeploymentConfigRequest
  ): IO[AwsError, Unit]
  def listDeployments(
      request: ListDeploymentsRequest
  ): ZStream[Any, AwsError, DeploymentId]
  def listDeploymentsPaginated(
      request: ListDeploymentsRequest
  ): IO[AwsError, ReadOnly]
  def getDeploymentConfig(
      request: GetDeploymentConfigRequest
  ): IO[AwsError, zio.aws.codedeploy.model.GetDeploymentConfigResponse.ReadOnly]
  def deregisterOnPremisesInstance(
      request: DeregisterOnPremisesInstanceRequest
  ): IO[AwsError, Unit]
  def getDeploymentGroup(
      request: GetDeploymentGroupRequest
  ): IO[AwsError, zio.aws.codedeploy.model.GetDeploymentGroupResponse.ReadOnly]
  def addTagsToOnPremisesInstances(
      request: AddTagsToOnPremisesInstancesRequest
  ): IO[AwsError, Unit]
  def listDeploymentGroups(
      request: ListDeploymentGroupsRequest
  ): ZStream[Any, AwsError, DeploymentGroupName]
  def listDeploymentGroupsPaginated(request: ListDeploymentGroupsRequest): IO[
    AwsError,
    zio.aws.codedeploy.model.ListDeploymentGroupsResponse.ReadOnly
  ]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.codedeploy.model.UntagResourceResponse.ReadOnly]
  def getApplicationRevision(request: GetApplicationRevisionRequest): IO[
    AwsError,
    zio.aws.codedeploy.model.GetApplicationRevisionResponse.ReadOnly
  ]
  def createDeployment(
      request: CreateDeploymentRequest
  ): IO[AwsError, zio.aws.codedeploy.model.CreateDeploymentResponse.ReadOnly]
  def registerApplicationRevision(
      request: RegisterApplicationRevisionRequest
  ): IO[AwsError, Unit]
  def batchGetApplications(request: BatchGetApplicationsRequest): IO[
    AwsError,
    zio.aws.codedeploy.model.BatchGetApplicationsResponse.ReadOnly
  ]
  def deleteGitHubAccountToken(request: DeleteGitHubAccountTokenRequest): IO[
    AwsError,
    zio.aws.codedeploy.model.DeleteGitHubAccountTokenResponse.ReadOnly
  ]
  def deleteDeploymentGroup(request: DeleteDeploymentGroupRequest): IO[
    AwsError,
    zio.aws.codedeploy.model.DeleteDeploymentGroupResponse.ReadOnly
  ]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): ZStream[Any, AwsError, zio.aws.codedeploy.model.Tag.ReadOnly]
  def listTagsForResourcePaginated(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.codedeploy.model.ListTagsForResourceResponse.ReadOnly]
  def batchGetApplicationRevisions(
      request: BatchGetApplicationRevisionsRequest
  ): IO[
    AwsError,
    zio.aws.codedeploy.model.BatchGetApplicationRevisionsResponse.ReadOnly
  ]
  def getOnPremisesInstance(request: GetOnPremisesInstanceRequest): IO[
    AwsError,
    zio.aws.codedeploy.model.GetOnPremisesInstanceResponse.ReadOnly
  ]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.codedeploy.model.TagResourceResponse.ReadOnly]
  def getDeploymentTarget(
      request: GetDeploymentTargetRequest
  ): IO[AwsError, zio.aws.codedeploy.model.GetDeploymentTargetResponse.ReadOnly]
  def listApplications(
      request: ListApplicationsRequest
  ): ZStream[Any, AwsError, ApplicationName]
  def listApplicationsPaginated(
      request: ListApplicationsRequest
  ): IO[AwsError, zio.aws.codedeploy.model.ListApplicationsResponse.ReadOnly]
  def batchGetDeploymentGroups(request: BatchGetDeploymentGroupsRequest): IO[
    AwsError,
    zio.aws.codedeploy.model.BatchGetDeploymentGroupsResponse.ReadOnly
  ]
  def listDeploymentTargets(request: ListDeploymentTargetsRequest): IO[
    AwsError,
    zio.aws.codedeploy.model.ListDeploymentTargetsResponse.ReadOnly
  ]
  def batchGetOnPremisesInstances(
      request: BatchGetOnPremisesInstancesRequest
  ): IO[
    AwsError,
    zio.aws.codedeploy.model.BatchGetOnPremisesInstancesResponse.ReadOnly
  ]
  def updateApplication(request: UpdateApplicationRequest): IO[AwsError, Unit]
  def batchGetDeploymentTargets(request: BatchGetDeploymentTargetsRequest): IO[
    AwsError,
    zio.aws.codedeploy.model.BatchGetDeploymentTargetsResponse.ReadOnly
  ]
  def batchGetDeployments(
      request: BatchGetDeploymentsRequest
  ): IO[AwsError, zio.aws.codedeploy.model.BatchGetDeploymentsResponse.ReadOnly]
  def putLifecycleEventHookExecutionStatus(
      request: PutLifecycleEventHookExecutionStatusRequest
  ): IO[
    AwsError,
    zio.aws.codedeploy.model.PutLifecycleEventHookExecutionStatusResponse.ReadOnly
  ]
  def createDeploymentGroup(request: CreateDeploymentGroupRequest): IO[
    AwsError,
    zio.aws.codedeploy.model.CreateDeploymentGroupResponse.ReadOnly
  ]
}
object CodeDeploy {
  val live: ZLayer[AwsConfig, java.lang.Throwable, CodeDeploy] = customized(
    identity
  )
  def customized(
      customization: CodeDeployAsyncClientBuilder => CodeDeployAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, CodeDeploy] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: CodeDeployAsyncClientBuilder => CodeDeployAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, CodeDeploy] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = CodeDeployAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[CodeDeployAsyncClient, CodeDeployAsyncClientBuilder](builder);
    b1 <- awsConfig
      .configureHttpClient[CodeDeployAsyncClient, CodeDeployAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new CodeDeployImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class CodeDeployImpl[R](
      override val api: CodeDeployAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends CodeDeploy
      with AwsServiceBase[R] {
    override val serviceName: String = "CodeDeploy"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): CodeDeployImpl[R1] = new CodeDeployImpl(api, newAspect, r)
    def removeTagsFromOnPremisesInstances(
        request: RemoveTagsFromOnPremisesInstancesRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.RemoveTagsFromOnPremisesInstancesRequest,
      RemoveTagsFromOnPremisesInstancesResponse
    ](
      "removeTagsFromOnPremisesInstances",
      api.removeTagsFromOnPremisesInstances
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def stopDeployment(
        request: StopDeploymentRequest
    ): IO[AwsError, zio.aws.codedeploy.model.StopDeploymentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codedeploy.model.StopDeploymentRequest,
        StopDeploymentResponse
      ]("stopDeployment", api.stopDeployment)(request.buildAwsValue())
        .map(zio.aws.codedeploy.model.StopDeploymentResponse.wrap)
        .provideEnvironment(r)
    def getApplication(
        request: GetApplicationRequest
    ): IO[AwsError, zio.aws.codedeploy.model.GetApplicationResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codedeploy.model.GetApplicationRequest,
        GetApplicationResponse
      ]("getApplication", api.getApplication)(request.buildAwsValue())
        .map(zio.aws.codedeploy.model.GetApplicationResponse.wrap)
        .provideEnvironment(r)
    def listDeploymentConfigs(
        request: ListDeploymentConfigsRequest
    ): ZStream[Any, AwsError, DeploymentConfigName] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest,
      java.lang.String,
      ListDeploymentConfigsPublisher
    ](
      "listDeploymentConfigs",
      api.listDeploymentConfigsPaginator,
      _.deploymentConfigsList()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.codedeploy.model.primitives.DeploymentConfigName(item)
      )
      .provideEnvironment(r)
    def listDeploymentConfigsPaginated(
        request: ListDeploymentConfigsRequest
    ): IO[
      AwsError,
      zio.aws.codedeploy.model.ListDeploymentConfigsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest,
      ListDeploymentConfigsResponse
    ]("listDeploymentConfigs", api.listDeploymentConfigs)(
      request.buildAwsValue()
    ).map(zio.aws.codedeploy.model.ListDeploymentConfigsResponse.wrap)
      .provideEnvironment(r)
    def deleteApplication(
        request: DeleteApplicationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.DeleteApplicationRequest,
      DeleteApplicationResponse
    ]("deleteApplication", api.deleteApplication)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def listOnPremisesInstances(request: ListOnPremisesInstancesRequest): IO[
      AwsError,
      zio.aws.codedeploy.model.ListOnPremisesInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.ListOnPremisesInstancesRequest,
      ListOnPremisesInstancesResponse
    ]("listOnPremisesInstances", api.listOnPremisesInstances)(
      request.buildAwsValue()
    ).map(zio.aws.codedeploy.model.ListOnPremisesInstancesResponse.wrap)
      .provideEnvironment(r)
    def continueDeployment(
        request: ContinueDeploymentRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.ContinueDeploymentRequest,
      ContinueDeploymentResponse
    ]("continueDeployment", api.continueDeployment)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def updateDeploymentGroup(request: UpdateDeploymentGroupRequest): IO[
      AwsError,
      zio.aws.codedeploy.model.UpdateDeploymentGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.UpdateDeploymentGroupRequest,
      UpdateDeploymentGroupResponse
    ]("updateDeploymentGroup", api.updateDeploymentGroup)(
      request.buildAwsValue()
    ).map(zio.aws.codedeploy.model.UpdateDeploymentGroupResponse.wrap)
      .provideEnvironment(r)
    def deleteResourcesByExternalId(
        request: DeleteResourcesByExternalIdRequest
    ): IO[
      AwsError,
      zio.aws.codedeploy.model.DeleteResourcesByExternalIdResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.DeleteResourcesByExternalIdRequest,
      DeleteResourcesByExternalIdResponse
    ]("deleteResourcesByExternalId", api.deleteResourcesByExternalId)(
      request.buildAwsValue()
    ).map(zio.aws.codedeploy.model.DeleteResourcesByExternalIdResponse.wrap)
      .provideEnvironment(r)
    def listGitHubAccountTokenNames(
        request: ListGitHubAccountTokenNamesRequest
    ): IO[
      AwsError,
      zio.aws.codedeploy.model.ListGitHubAccountTokenNamesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.ListGitHubAccountTokenNamesRequest,
      ListGitHubAccountTokenNamesResponse
    ]("listGitHubAccountTokenNames", api.listGitHubAccountTokenNames)(
      request.buildAwsValue()
    ).map(zio.aws.codedeploy.model.ListGitHubAccountTokenNamesResponse.wrap)
      .provideEnvironment(r)
    def getDeployment(
        request: GetDeploymentRequest
    ): IO[AwsError, zio.aws.codedeploy.model.GetDeploymentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codedeploy.model.GetDeploymentRequest,
        GetDeploymentResponse
      ]("getDeployment", api.getDeployment)(request.buildAwsValue())
        .map(zio.aws.codedeploy.model.GetDeploymentResponse.wrap)
        .provideEnvironment(r)
    def createDeploymentConfig(request: CreateDeploymentConfigRequest): IO[
      AwsError,
      zio.aws.codedeploy.model.CreateDeploymentConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.CreateDeploymentConfigRequest,
      CreateDeploymentConfigResponse
    ]("createDeploymentConfig", api.createDeploymentConfig)(
      request.buildAwsValue()
    ).map(zio.aws.codedeploy.model.CreateDeploymentConfigResponse.wrap)
      .provideEnvironment(r)
    def createApplication(request: CreateApplicationRequest): IO[
      AwsError,
      zio.aws.codedeploy.model.CreateApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.CreateApplicationRequest,
      CreateApplicationResponse
    ]("createApplication", api.createApplication)(request.buildAwsValue())
      .map(zio.aws.codedeploy.model.CreateApplicationResponse.wrap)
      .provideEnvironment(r)
    def listApplicationRevisions(
        request: ListApplicationRevisionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.codedeploy.model.RevisionLocation.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest,
      RevisionLocation,
      ListApplicationRevisionsPublisher
    ](
      "listApplicationRevisions",
      api.listApplicationRevisionsPaginator,
      _.revisions()
    )(request.buildAwsValue())
      .map(item => zio.aws.codedeploy.model.RevisionLocation.wrap(item))
      .provideEnvironment(r)
    def listApplicationRevisionsPaginated(
        request: ListApplicationRevisionsRequest
    ): IO[
      AwsError,
      zio.aws.codedeploy.model.ListApplicationRevisionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest,
      ListApplicationRevisionsResponse
    ]("listApplicationRevisions", api.listApplicationRevisions)(
      request.buildAwsValue()
    ).map(zio.aws.codedeploy.model.ListApplicationRevisionsResponse.wrap)
      .provideEnvironment(r)
    def registerOnPremisesInstance(
        request: RegisterOnPremisesInstanceRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.RegisterOnPremisesInstanceRequest,
      RegisterOnPremisesInstanceResponse
    ]("registerOnPremisesInstance", api.registerOnPremisesInstance)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteDeploymentConfig(
        request: DeleteDeploymentConfigRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentConfigRequest,
      DeleteDeploymentConfigResponse
    ]("deleteDeploymentConfig", api.deleteDeploymentConfig)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listDeployments(
        request: ListDeploymentsRequest
    ): ZStream[Any, AwsError, DeploymentId] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.codedeploy.model.ListDeploymentsRequest,
      java.lang.String,
      ListDeploymentsPublisher
    ]("listDeployments", api.listDeploymentsPaginator, _.deployments())(
      request.buildAwsValue()
    ).map(item => zio.aws.codedeploy.model.primitives.DeploymentId(item))
      .provideEnvironment(r)
    def listDeploymentsPaginated(
        request: ListDeploymentsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.ListDeploymentsRequest,
      ListDeploymentsResponse
    ]("listDeployments", api.listDeployments)(request.buildAwsValue())
      .map(zio.aws.codedeploy.model.ListDeploymentsResponse.wrap)
      .provideEnvironment(r)
    def getDeploymentConfig(request: GetDeploymentConfigRequest): IO[
      AwsError,
      zio.aws.codedeploy.model.GetDeploymentConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.GetDeploymentConfigRequest,
      GetDeploymentConfigResponse
    ]("getDeploymentConfig", api.getDeploymentConfig)(request.buildAwsValue())
      .map(zio.aws.codedeploy.model.GetDeploymentConfigResponse.wrap)
      .provideEnvironment(r)
    def deregisterOnPremisesInstance(
        request: DeregisterOnPremisesInstanceRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.DeregisterOnPremisesInstanceRequest,
      DeregisterOnPremisesInstanceResponse
    ]("deregisterOnPremisesInstance", api.deregisterOnPremisesInstance)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getDeploymentGroup(request: GetDeploymentGroupRequest): IO[
      AwsError,
      zio.aws.codedeploy.model.GetDeploymentGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.GetDeploymentGroupRequest,
      GetDeploymentGroupResponse
    ]("getDeploymentGroup", api.getDeploymentGroup)(request.buildAwsValue())
      .map(zio.aws.codedeploy.model.GetDeploymentGroupResponse.wrap)
      .provideEnvironment(r)
    def addTagsToOnPremisesInstances(
        request: AddTagsToOnPremisesInstancesRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.AddTagsToOnPremisesInstancesRequest,
      AddTagsToOnPremisesInstancesResponse
    ]("addTagsToOnPremisesInstances", api.addTagsToOnPremisesInstances)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listDeploymentGroups(
        request: ListDeploymentGroupsRequest
    ): ZStream[Any, AwsError, DeploymentGroupName] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsRequest,
      java.lang.String,
      ListDeploymentGroupsPublisher
    ](
      "listDeploymentGroups",
      api.listDeploymentGroupsPaginator,
      _.deploymentGroups()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.codedeploy.model.primitives.DeploymentGroupName(item)
      )
      .provideEnvironment(r)
    def listDeploymentGroupsPaginated(request: ListDeploymentGroupsRequest): IO[
      AwsError,
      zio.aws.codedeploy.model.ListDeploymentGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsRequest,
      ListDeploymentGroupsResponse
    ]("listDeploymentGroups", api.listDeploymentGroups)(request.buildAwsValue())
      .map(zio.aws.codedeploy.model.ListDeploymentGroupsResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.codedeploy.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codedeploy.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.codedeploy.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def getApplicationRevision(request: GetApplicationRevisionRequest): IO[
      AwsError,
      zio.aws.codedeploy.model.GetApplicationRevisionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.GetApplicationRevisionRequest,
      GetApplicationRevisionResponse
    ]("getApplicationRevision", api.getApplicationRevision)(
      request.buildAwsValue()
    ).map(zio.aws.codedeploy.model.GetApplicationRevisionResponse.wrap)
      .provideEnvironment(r)
    def createDeployment(request: CreateDeploymentRequest): IO[
      AwsError,
      zio.aws.codedeploy.model.CreateDeploymentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.CreateDeploymentRequest,
      CreateDeploymentResponse
    ]("createDeployment", api.createDeployment)(request.buildAwsValue())
      .map(zio.aws.codedeploy.model.CreateDeploymentResponse.wrap)
      .provideEnvironment(r)
    def registerApplicationRevision(
        request: RegisterApplicationRevisionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.RegisterApplicationRevisionRequest,
      RegisterApplicationRevisionResponse
    ]("registerApplicationRevision", api.registerApplicationRevision)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def batchGetApplications(request: BatchGetApplicationsRequest): IO[
      AwsError,
      zio.aws.codedeploy.model.BatchGetApplicationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationsRequest,
      BatchGetApplicationsResponse
    ]("batchGetApplications", api.batchGetApplications)(request.buildAwsValue())
      .map(zio.aws.codedeploy.model.BatchGetApplicationsResponse.wrap)
      .provideEnvironment(r)
    def deleteGitHubAccountToken(request: DeleteGitHubAccountTokenRequest): IO[
      AwsError,
      zio.aws.codedeploy.model.DeleteGitHubAccountTokenResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.DeleteGitHubAccountTokenRequest,
      DeleteGitHubAccountTokenResponse
    ]("deleteGitHubAccountToken", api.deleteGitHubAccountToken)(
      request.buildAwsValue()
    ).map(zio.aws.codedeploy.model.DeleteGitHubAccountTokenResponse.wrap)
      .provideEnvironment(r)
    def deleteDeploymentGroup(request: DeleteDeploymentGroupRequest): IO[
      AwsError,
      zio.aws.codedeploy.model.DeleteDeploymentGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.DeleteDeploymentGroupRequest,
      DeleteDeploymentGroupResponse
    ]("deleteDeploymentGroup", api.deleteDeploymentGroup)(
      request.buildAwsValue()
    ).map(zio.aws.codedeploy.model.DeleteDeploymentGroupResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: ListTagsForResourceRequest
    ): ZStream[Any, AwsError, zio.aws.codedeploy.model.Tag.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.codedeploy.model.ListTagsForResourceRequest,
        ListTagsForResourceResponse,
        Tag
      ](
        "listTagsForResource",
        api.listTagsForResource,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.tags().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.codedeploy.model.Tag.wrap(item))
        .provideEnvironment(r)
    def listTagsForResourcePaginated(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.codedeploy.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.codedeploy.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def batchGetApplicationRevisions(
        request: BatchGetApplicationRevisionsRequest
    ): IO[
      AwsError,
      zio.aws.codedeploy.model.BatchGetApplicationRevisionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationRevisionsRequest,
      BatchGetApplicationRevisionsResponse
    ]("batchGetApplicationRevisions", api.batchGetApplicationRevisions)(
      request.buildAwsValue()
    ).map(zio.aws.codedeploy.model.BatchGetApplicationRevisionsResponse.wrap)
      .provideEnvironment(r)
    def getOnPremisesInstance(request: GetOnPremisesInstanceRequest): IO[
      AwsError,
      zio.aws.codedeploy.model.GetOnPremisesInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.GetOnPremisesInstanceRequest,
      GetOnPremisesInstanceResponse
    ]("getOnPremisesInstance", api.getOnPremisesInstance)(
      request.buildAwsValue()
    ).map(zio.aws.codedeploy.model.GetOnPremisesInstanceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.codedeploy.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codedeploy.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.codedeploy.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def getDeploymentTarget(request: GetDeploymentTargetRequest): IO[
      AwsError,
      zio.aws.codedeploy.model.GetDeploymentTargetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.GetDeploymentTargetRequest,
      GetDeploymentTargetResponse
    ]("getDeploymentTarget", api.getDeploymentTarget)(request.buildAwsValue())
      .map(zio.aws.codedeploy.model.GetDeploymentTargetResponse.wrap)
      .provideEnvironment(r)
    def listApplications(
        request: ListApplicationsRequest
    ): ZStream[Any, AwsError, ApplicationName] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest,
      java.lang.String,
      ListApplicationsPublisher
    ]("listApplications", api.listApplicationsPaginator, _.applications())(
      request.buildAwsValue()
    ).map(item => zio.aws.codedeploy.model.primitives.ApplicationName(item))
      .provideEnvironment(r)
    def listApplicationsPaginated(request: ListApplicationsRequest): IO[
      AwsError,
      zio.aws.codedeploy.model.ListApplicationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest,
      ListApplicationsResponse
    ]("listApplications", api.listApplications)(request.buildAwsValue())
      .map(zio.aws.codedeploy.model.ListApplicationsResponse.wrap)
      .provideEnvironment(r)
    def batchGetDeploymentGroups(request: BatchGetDeploymentGroupsRequest): IO[
      AwsError,
      zio.aws.codedeploy.model.BatchGetDeploymentGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentGroupsRequest,
      BatchGetDeploymentGroupsResponse
    ]("batchGetDeploymentGroups", api.batchGetDeploymentGroups)(
      request.buildAwsValue()
    ).map(zio.aws.codedeploy.model.BatchGetDeploymentGroupsResponse.wrap)
      .provideEnvironment(r)
    def listDeploymentTargets(request: ListDeploymentTargetsRequest): IO[
      AwsError,
      zio.aws.codedeploy.model.ListDeploymentTargetsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsRequest,
      ListDeploymentTargetsResponse
    ]("listDeploymentTargets", api.listDeploymentTargets)(
      request.buildAwsValue()
    ).map(zio.aws.codedeploy.model.ListDeploymentTargetsResponse.wrap)
      .provideEnvironment(r)
    def batchGetOnPremisesInstances(
        request: BatchGetOnPremisesInstancesRequest
    ): IO[
      AwsError,
      zio.aws.codedeploy.model.BatchGetOnPremisesInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.BatchGetOnPremisesInstancesRequest,
      BatchGetOnPremisesInstancesResponse
    ]("batchGetOnPremisesInstances", api.batchGetOnPremisesInstances)(
      request.buildAwsValue()
    ).map(zio.aws.codedeploy.model.BatchGetOnPremisesInstancesResponse.wrap)
      .provideEnvironment(r)
    def updateApplication(
        request: UpdateApplicationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.UpdateApplicationRequest,
      UpdateApplicationResponse
    ]("updateApplication", api.updateApplication)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def batchGetDeploymentTargets(
        request: BatchGetDeploymentTargetsRequest
    ): IO[
      AwsError,
      zio.aws.codedeploy.model.BatchGetDeploymentTargetsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentTargetsRequest,
      BatchGetDeploymentTargetsResponse
    ]("batchGetDeploymentTargets", api.batchGetDeploymentTargets)(
      request.buildAwsValue()
    ).map(zio.aws.codedeploy.model.BatchGetDeploymentTargetsResponse.wrap)
      .provideEnvironment(r)
    def batchGetDeployments(request: BatchGetDeploymentsRequest): IO[
      AwsError,
      zio.aws.codedeploy.model.BatchGetDeploymentsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentsRequest,
      BatchGetDeploymentsResponse
    ]("batchGetDeployments", api.batchGetDeployments)(request.buildAwsValue())
      .map(zio.aws.codedeploy.model.BatchGetDeploymentsResponse.wrap)
      .provideEnvironment(r)
    def putLifecycleEventHookExecutionStatus(
        request: PutLifecycleEventHookExecutionStatusRequest
    ): IO[
      AwsError,
      zio.aws.codedeploy.model.PutLifecycleEventHookExecutionStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.PutLifecycleEventHookExecutionStatusRequest,
      PutLifecycleEventHookExecutionStatusResponse
    ](
      "putLifecycleEventHookExecutionStatus",
      api.putLifecycleEventHookExecutionStatus
    )(request.buildAwsValue())
      .map(
        zio.aws.codedeploy.model.PutLifecycleEventHookExecutionStatusResponse.wrap
      )
      .provideEnvironment(r)
    def createDeploymentGroup(request: CreateDeploymentGroupRequest): IO[
      AwsError,
      zio.aws.codedeploy.model.CreateDeploymentGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codedeploy.model.CreateDeploymentGroupRequest,
      CreateDeploymentGroupResponse
    ]("createDeploymentGroup", api.createDeploymentGroup)(
      request.buildAwsValue()
    ).map(zio.aws.codedeploy.model.CreateDeploymentGroupResponse.wrap)
      .provideEnvironment(r)
  }
  def removeTagsFromOnPremisesInstances(
      request: RemoveTagsFromOnPremisesInstancesRequest
  ): ZIO[zio.aws.codedeploy.CodeDeploy, AwsError, Unit] =
    ZIO.serviceWithZIO(_.removeTagsFromOnPremisesInstances(request))
  def stopDeployment(request: StopDeploymentRequest): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.StopDeploymentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopDeployment(request))
  def getApplication(request: GetApplicationRequest): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.GetApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getApplication(request))
  def listDeploymentConfigs(
      request: ListDeploymentConfigsRequest
  ): ZStream[zio.aws.codedeploy.CodeDeploy, AwsError, DeploymentConfigName] =
    ZStream.serviceWithStream(_.listDeploymentConfigs(request))
  def listDeploymentConfigsPaginated(
      request: ListDeploymentConfigsRequest
  ): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.ListDeploymentConfigsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDeploymentConfigsPaginated(request))
  def deleteApplication(
      request: DeleteApplicationRequest
  ): ZIO[zio.aws.codedeploy.CodeDeploy, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteApplication(request))
  def listOnPremisesInstances(request: ListOnPremisesInstancesRequest): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.ListOnPremisesInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listOnPremisesInstances(request))
  def continueDeployment(
      request: ContinueDeploymentRequest
  ): ZIO[zio.aws.codedeploy.CodeDeploy, AwsError, Unit] =
    ZIO.serviceWithZIO(_.continueDeployment(request))
  def updateDeploymentGroup(request: UpdateDeploymentGroupRequest): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.UpdateDeploymentGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDeploymentGroup(request))
  def deleteResourcesByExternalId(
      request: DeleteResourcesByExternalIdRequest
  ): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.DeleteResourcesByExternalIdResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteResourcesByExternalId(request))
  def listGitHubAccountTokenNames(
      request: ListGitHubAccountTokenNamesRequest
  ): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.ListGitHubAccountTokenNamesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listGitHubAccountTokenNames(request))
  def getDeployment(request: GetDeploymentRequest): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.GetDeploymentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDeployment(request))
  def createDeploymentConfig(request: CreateDeploymentConfigRequest): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.CreateDeploymentConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDeploymentConfig(request))
  def createApplication(request: CreateApplicationRequest): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.CreateApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createApplication(request))
  def listApplicationRevisions(
      request: ListApplicationRevisionsRequest
  ): ZStream[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.RevisionLocation.ReadOnly
  ] = ZStream.serviceWithStream(_.listApplicationRevisions(request))
  def listApplicationRevisionsPaginated(
      request: ListApplicationRevisionsRequest
  ): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.ListApplicationRevisionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listApplicationRevisionsPaginated(request))
  def registerOnPremisesInstance(
      request: RegisterOnPremisesInstanceRequest
  ): ZIO[zio.aws.codedeploy.CodeDeploy, AwsError, Unit] =
    ZIO.serviceWithZIO(_.registerOnPremisesInstance(request))
  def deleteDeploymentConfig(
      request: DeleteDeploymentConfigRequest
  ): ZIO[zio.aws.codedeploy.CodeDeploy, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDeploymentConfig(request))
  def listDeployments(
      request: ListDeploymentsRequest
  ): ZStream[zio.aws.codedeploy.CodeDeploy, AwsError, DeploymentId] =
    ZStream.serviceWithStream(_.listDeployments(request))
  def listDeploymentsPaginated(
      request: ListDeploymentsRequest
  ): ZIO[zio.aws.codedeploy.CodeDeploy, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listDeploymentsPaginated(request))
  def getDeploymentConfig(request: GetDeploymentConfigRequest): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.GetDeploymentConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDeploymentConfig(request))
  def deregisterOnPremisesInstance(
      request: DeregisterOnPremisesInstanceRequest
  ): ZIO[zio.aws.codedeploy.CodeDeploy, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deregisterOnPremisesInstance(request))
  def getDeploymentGroup(request: GetDeploymentGroupRequest): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.GetDeploymentGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDeploymentGroup(request))
  def addTagsToOnPremisesInstances(
      request: AddTagsToOnPremisesInstancesRequest
  ): ZIO[zio.aws.codedeploy.CodeDeploy, AwsError, Unit] =
    ZIO.serviceWithZIO(_.addTagsToOnPremisesInstances(request))
  def listDeploymentGroups(
      request: ListDeploymentGroupsRequest
  ): ZStream[zio.aws.codedeploy.CodeDeploy, AwsError, DeploymentGroupName] =
    ZStream.serviceWithStream(_.listDeploymentGroups(request))
  def listDeploymentGroupsPaginated(request: ListDeploymentGroupsRequest): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.ListDeploymentGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDeploymentGroupsPaginated(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def getApplicationRevision(request: GetApplicationRevisionRequest): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.GetApplicationRevisionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getApplicationRevision(request))
  def createDeployment(request: CreateDeploymentRequest): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.CreateDeploymentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDeployment(request))
  def registerApplicationRevision(
      request: RegisterApplicationRevisionRequest
  ): ZIO[zio.aws.codedeploy.CodeDeploy, AwsError, Unit] =
    ZIO.serviceWithZIO(_.registerApplicationRevision(request))
  def batchGetApplications(request: BatchGetApplicationsRequest): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.BatchGetApplicationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetApplications(request))
  def deleteGitHubAccountToken(request: DeleteGitHubAccountTokenRequest): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.DeleteGitHubAccountTokenResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteGitHubAccountToken(request))
  def deleteDeploymentGroup(request: DeleteDeploymentGroupRequest): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.DeleteDeploymentGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDeploymentGroup(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZStream[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.Tag.ReadOnly
  ] = ZStream.serviceWithStream(_.listTagsForResource(request))
  def listTagsForResourcePaginated(request: ListTagsForResourceRequest): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResourcePaginated(request))
  def batchGetApplicationRevisions(
      request: BatchGetApplicationRevisionsRequest
  ): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.BatchGetApplicationRevisionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetApplicationRevisions(request))
  def getOnPremisesInstance(request: GetOnPremisesInstanceRequest): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.GetOnPremisesInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getOnPremisesInstance(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def getDeploymentTarget(request: GetDeploymentTargetRequest): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.GetDeploymentTargetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDeploymentTarget(request))
  def listApplications(
      request: ListApplicationsRequest
  ): ZStream[zio.aws.codedeploy.CodeDeploy, AwsError, ApplicationName] =
    ZStream.serviceWithStream(_.listApplications(request))
  def listApplicationsPaginated(request: ListApplicationsRequest): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.ListApplicationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listApplicationsPaginated(request))
  def batchGetDeploymentGroups(request: BatchGetDeploymentGroupsRequest): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.BatchGetDeploymentGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetDeploymentGroups(request))
  def listDeploymentTargets(request: ListDeploymentTargetsRequest): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.ListDeploymentTargetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDeploymentTargets(request))
  def batchGetOnPremisesInstances(
      request: BatchGetOnPremisesInstancesRequest
  ): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.BatchGetOnPremisesInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetOnPremisesInstances(request))
  def updateApplication(
      request: UpdateApplicationRequest
  ): ZIO[zio.aws.codedeploy.CodeDeploy, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateApplication(request))
  def batchGetDeploymentTargets(request: BatchGetDeploymentTargetsRequest): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.BatchGetDeploymentTargetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetDeploymentTargets(request))
  def batchGetDeployments(request: BatchGetDeploymentsRequest): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.BatchGetDeploymentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetDeployments(request))
  def putLifecycleEventHookExecutionStatus(
      request: PutLifecycleEventHookExecutionStatusRequest
  ): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.PutLifecycleEventHookExecutionStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putLifecycleEventHookExecutionStatus(request))
  def createDeploymentGroup(request: CreateDeploymentGroupRequest): ZIO[
    zio.aws.codedeploy.CodeDeploy,
    AwsError,
    zio.aws.codedeploy.model.CreateDeploymentGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDeploymentGroup(request))
}
