package zio.aws.codedeploy.model
import zio.prelude.data.Optional
import zio.aws.codedeploy.model.primitives.{WaitTimeInMins, Percentage}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class TimeBasedCanary(
    canaryPercentage: Optional[Percentage] = Optional.Absent,
    canaryInterval: Optional[WaitTimeInMins] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.TimeBasedCanary = {
    import TimeBasedCanary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.TimeBasedCanary
      .builder()
      .optionallyWith(
        canaryPercentage.map(value => Percentage.unwrap(value): Integer)
      )(_.canaryPercentage)
      .optionallyWith(
        canaryInterval.map(value => WaitTimeInMins.unwrap(value): Integer)
      )(_.canaryInterval)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.TimeBasedCanary.ReadOnly =
    zio.aws.codedeploy.model.TimeBasedCanary.wrap(buildAwsValue())
}
object TimeBasedCanary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.TimeBasedCanary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.TimeBasedCanary =
      zio.aws.codedeploy.model.TimeBasedCanary(
        canaryPercentage.map(value => value),
        canaryInterval.map(value => value)
      )
    def canaryPercentage: Optional[Percentage]
    def canaryInterval: Optional[WaitTimeInMins]
    def getCanaryPercentage: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("canaryPercentage", canaryPercentage)
    def getCanaryInterval: ZIO[Any, AwsError, WaitTimeInMins] =
      AwsError.unwrapOptionField("canaryInterval", canaryInterval)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.TimeBasedCanary
  ) extends zio.aws.codedeploy.model.TimeBasedCanary.ReadOnly {
    override val canaryPercentage: Optional[Percentage] = zio.aws.core.internal
      .optionalFromNullable(impl.canaryPercentage())
      .map(value => zio.aws.codedeploy.model.primitives.Percentage(value))
    override val canaryInterval: Optional[WaitTimeInMins] =
      zio.aws.core.internal
        .optionalFromNullable(impl.canaryInterval())
        .map(value => zio.aws.codedeploy.model.primitives.WaitTimeInMins(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.TimeBasedCanary
  ): zio.aws.codedeploy.model.TimeBasedCanary.ReadOnly = new Wrapper(impl)
}
