package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{ETag, VersionId, S3Key, S3Bucket}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class S3Location(
    bucket: Optional[S3Bucket] = Optional.Absent,
    key: Optional[S3Key] = Optional.Absent,
    bundleType: Optional[zio.aws.codedeploy.model.BundleType] = Optional.Absent,
    version: Optional[VersionId] = Optional.Absent,
    eTag: Optional[ETag] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.S3Location = {
    import S3Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.S3Location
      .builder()
      .optionallyWith(
        bucket.map(value => S3Bucket.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(key.map(value => S3Key.unwrap(value): java.lang.String))(
        _.key
      )
      .optionallyWith(bundleType.map(value => value.unwrap))(_.bundleType)
      .optionallyWith(
        version.map(value => VersionId.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(eTag.map(value => ETag.unwrap(value): java.lang.String))(
        _.eTag
      )
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.S3Location.ReadOnly =
    zio.aws.codedeploy.model.S3Location.wrap(buildAwsValue())
}
object S3Location {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.S3Location
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.S3Location =
      zio.aws.codedeploy.model.S3Location(
        bucket.map(value => value),
        key.map(value => value),
        bundleType.map(value => value),
        version.map(value => value),
        eTag.map(value => value)
      )
    def bucket: Optional[S3Bucket]
    def key: Optional[S3Key]
    def bundleType: Optional[zio.aws.codedeploy.model.BundleType]
    def version: Optional[VersionId]
    def eTag: Optional[ETag]
    def getBucket: ZIO[Any, AwsError, S3Bucket] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getKey: ZIO[Any, AwsError, S3Key] =
      AwsError.unwrapOptionField("key", key)
    def getBundleType: ZIO[Any, AwsError, zio.aws.codedeploy.model.BundleType] =
      AwsError.unwrapOptionField("bundleType", bundleType)
    def getVersion: ZIO[Any, AwsError, VersionId] =
      AwsError.unwrapOptionField("version", version)
    def getETag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.S3Location
  ) extends zio.aws.codedeploy.model.S3Location.ReadOnly {
    override val bucket: Optional[S3Bucket] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => zio.aws.codedeploy.model.primitives.S3Bucket(value))
    override val key: Optional[S3Key] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.codedeploy.model.primitives.S3Key(value))
    override val bundleType: Optional[zio.aws.codedeploy.model.BundleType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bundleType())
        .map(value => zio.aws.codedeploy.model.BundleType.wrap(value))
    override val version: Optional[VersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.codedeploy.model.primitives.VersionId(value))
    override val eTag: Optional[ETag] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => zio.aws.codedeploy.model.primitives.ETag(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.S3Location
  ): zio.aws.codedeploy.model.S3Location.ReadOnly = new Wrapper(impl)
}
