package zio.aws.codedeploy.model
import scala.jdk.CollectionConverters.*
sealed trait RevisionLocationType {
  def unwrap
      : software.amazon.awssdk.services.codedeploy.model.RevisionLocationType
}
object RevisionLocationType {
  def wrap(
      value: software.amazon.awssdk.services.codedeploy.model.RevisionLocationType
  ): zio.aws.codedeploy.model.RevisionLocationType = value match {
    case software.amazon.awssdk.services.codedeploy.model.RevisionLocationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codedeploy.model.RevisionLocationType.S3 =>
      val r = S3
      r
    case software.amazon.awssdk.services.codedeploy.model.RevisionLocationType.GIT_HUB =>
      val r = GitHub
      r
    case software.amazon.awssdk.services.codedeploy.model.RevisionLocationType.STRING =>
      val r = String
      r
    case software.amazon.awssdk.services.codedeploy.model.RevisionLocationType.APP_SPEC_CONTENT =>
      val r = AppSpecContent
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codedeploy.model.RevisionLocationType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.RevisionLocationType =
      software.amazon.awssdk.services.codedeploy.model.RevisionLocationType.UNKNOWN_TO_SDK_VERSION
  }
  case object S3 extends zio.aws.codedeploy.model.RevisionLocationType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.RevisionLocationType =
      software.amazon.awssdk.services.codedeploy.model.RevisionLocationType.S3
  }
  case object GitHub extends zio.aws.codedeploy.model.RevisionLocationType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.RevisionLocationType =
      software.amazon.awssdk.services.codedeploy.model.RevisionLocationType.GIT_HUB
  }
  case object String extends zio.aws.codedeploy.model.RevisionLocationType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.RevisionLocationType =
      software.amazon.awssdk.services.codedeploy.model.RevisionLocationType.STRING
  }
  case object AppSpecContent
      extends zio.aws.codedeploy.model.RevisionLocationType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.RevisionLocationType =
      software.amazon.awssdk.services.codedeploy.model.RevisionLocationType.APP_SPEC_CONTENT
  }
}
