package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codedeploy.model.primitives.ApplicationName
import scala.jdk.CollectionConverters.*
final case class BatchGetApplicationRevisionsRequest(
    applicationName: ApplicationName,
    revisions: Iterable[zio.aws.codedeploy.model.RevisionLocation]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationRevisionsRequest = {
    import BatchGetApplicationRevisionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationRevisionsRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .revisions(revisions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.BatchGetApplicationRevisionsRequest.ReadOnly =
    zio.aws.codedeploy.model.BatchGetApplicationRevisionsRequest
      .wrap(buildAwsValue())
}
object BatchGetApplicationRevisionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationRevisionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codedeploy.model.BatchGetApplicationRevisionsRequest =
      zio.aws.codedeploy.model.BatchGetApplicationRevisionsRequest(
        applicationName,
        revisions.map { item =>
          item.asEditable
        }
      )
    def applicationName: ApplicationName
    def revisions: List[zio.aws.codedeploy.model.RevisionLocation.ReadOnly]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getRevisions: ZIO[Any, Nothing, List[
      zio.aws.codedeploy.model.RevisionLocation.ReadOnly
    ]] = ZIO.succeed(revisions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationRevisionsRequest
  ) extends zio.aws.codedeploy.model.BatchGetApplicationRevisionsRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.codedeploy.model.primitives
        .ApplicationName(impl.applicationName())
    override val revisions
        : List[zio.aws.codedeploy.model.RevisionLocation.ReadOnly] = impl
      .revisions()
      .asScala
      .map { item =>
        zio.aws.codedeploy.model.RevisionLocation.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationRevisionsRequest
  ): zio.aws.codedeploy.model.BatchGetApplicationRevisionsRequest.ReadOnly =
    new Wrapper(impl)
}
