package zio.aws.codedeploy.model
import scala.jdk.CollectionConverters.*
sealed trait MinimumHealthyHostsType {
  def unwrap
      : software.amazon.awssdk.services.codedeploy.model.MinimumHealthyHostsType
}
object MinimumHealthyHostsType {
  def wrap(
      value: software.amazon.awssdk.services.codedeploy.model.MinimumHealthyHostsType
  ): zio.aws.codedeploy.model.MinimumHealthyHostsType = value match {
    case software.amazon.awssdk.services.codedeploy.model.MinimumHealthyHostsType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codedeploy.model.MinimumHealthyHostsType.HOST_COUNT =>
      val r = HOST_COUNT
      r
    case software.amazon.awssdk.services.codedeploy.model.MinimumHealthyHostsType.FLEET_PERCENT =>
      val r = FLEET_PERCENT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codedeploy.model.MinimumHealthyHostsType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.MinimumHealthyHostsType =
      software.amazon.awssdk.services.codedeploy.model.MinimumHealthyHostsType.UNKNOWN_TO_SDK_VERSION
  }
  case object HOST_COUNT
      extends zio.aws.codedeploy.model.MinimumHealthyHostsType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.MinimumHealthyHostsType =
      software.amazon.awssdk.services.codedeploy.model.MinimumHealthyHostsType.HOST_COUNT
  }
  case object FLEET_PERCENT
      extends zio.aws.codedeploy.model.MinimumHealthyHostsType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.MinimumHealthyHostsType =
      software.amazon.awssdk.services.codedeploy.model.MinimumHealthyHostsType.FLEET_PERCENT
  }
}
