package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.ListenerArn
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TrafficRoute(
    listenerArns: Optional[Iterable[ListenerArn]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.TrafficRoute = {
    import TrafficRoute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.TrafficRoute
      .builder()
      .optionallyWith(
        listenerArns.map(value =>
          value.map { item =>
            ListenerArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.listenerArns)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.TrafficRoute.ReadOnly =
    zio.aws.codedeploy.model.TrafficRoute.wrap(buildAwsValue())
}
object TrafficRoute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.TrafficRoute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.TrafficRoute =
      zio.aws.codedeploy.model.TrafficRoute(listenerArns.map(value => value))
    def listenerArns: Optional[List[ListenerArn]]
    def getListenerArns: ZIO[Any, AwsError, List[ListenerArn]] =
      AwsError.unwrapOptionField("listenerArns", listenerArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.TrafficRoute
  ) extends zio.aws.codedeploy.model.TrafficRoute.ReadOnly {
    override val listenerArns: Optional[List[ListenerArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.listenerArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.primitives.ListenerArn(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.TrafficRoute
  ): zio.aws.codedeploy.model.TrafficRoute.ReadOnly = new Wrapper(impl)
}
