package zio.aws.codedeploy.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.codedeploy.model.primitives.Timestamp
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class TimeRange(
    start: Optional[Timestamp] = Optional.Absent,
    end: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.TimeRange = {
    import TimeRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.TimeRange
      .builder()
      .optionallyWith(start.map(value => Timestamp.unwrap(value): Instant))(
        _.start
      )
      .optionallyWith(end.map(value => Timestamp.unwrap(value): Instant))(_.end)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.TimeRange.ReadOnly =
    zio.aws.codedeploy.model.TimeRange.wrap(buildAwsValue())
}
object TimeRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.TimeRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.TimeRange =
      zio.aws.codedeploy.model
        .TimeRange(start.map(value => value), end.map(value => value))
    def start: Optional[Timestamp]
    def end: Optional[Timestamp]
    def getStart: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("start", start)
    def getEnd: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("end", end)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.TimeRange
  ) extends zio.aws.codedeploy.model.TimeRange.ReadOnly {
    override val start: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.start())
      .map(value => zio.aws.codedeploy.model.primitives.Timestamp(value))
    override val end: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.end())
      .map(value => zio.aws.codedeploy.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.TimeRange
  ): zio.aws.codedeploy.model.TimeRange.ReadOnly = new Wrapper(impl)
}
