package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{Value, Key}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TagFilter(
    key: Optional[Key] = Optional.Absent,
    value: Optional[Value] = Optional.Absent,
    `type`: Optional[zio.aws.codedeploy.model.TagFilterType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.TagFilter = {
    import TagFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.TagFilter
      .builder()
      .optionallyWith(key.map(value => Key.unwrap(value): java.lang.String))(
        _.key
      )
      .optionallyWith(
        value.map(value => Value.unwrap(value): java.lang.String)
      )(_.value)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.TagFilter.ReadOnly =
    zio.aws.codedeploy.model.TagFilter.wrap(buildAwsValue())
}
object TagFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.TagFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.TagFilter =
      zio.aws.codedeploy.model.TagFilter(
        key.map(value => value),
        value.map(value => value),
        `type`.map(value => value)
      )
    def key: Optional[Key]
    def value: Optional[Value]
    def `type`: Optional[zio.aws.codedeploy.model.TagFilterType]
    def getKey: ZIO[Any, AwsError, Key] = AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, Value] =
      AwsError.unwrapOptionField("value", value)
    def getType: ZIO[Any, AwsError, zio.aws.codedeploy.model.TagFilterType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.TagFilter
  ) extends zio.aws.codedeploy.model.TagFilter.ReadOnly {
    override val key: Optional[Key] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.codedeploy.model.primitives.Key(value))
    override val value: Optional[Value] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.codedeploy.model.primitives.Value(value))
    override val `type`: Optional[zio.aws.codedeploy.model.TagFilterType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.codedeploy.model.TagFilterType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.TagFilter
  ): zio.aws.codedeploy.model.TagFilter.ReadOnly = new Wrapper(impl)
}
