package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{
  TrafficWeight,
  Version,
  LambdaFunctionAlias,
  LambdaFunctionName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LambdaFunctionInfo(
    functionName: Optional[LambdaFunctionName] = Optional.Absent,
    functionAlias: Optional[LambdaFunctionAlias] = Optional.Absent,
    currentVersion: Optional[Version] = Optional.Absent,
    targetVersion: Optional[Version] = Optional.Absent,
    targetVersionWeight: Optional[TrafficWeight] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.LambdaFunctionInfo = {
    import LambdaFunctionInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.LambdaFunctionInfo
      .builder()
      .optionallyWith(
        functionName.map(value =>
          LambdaFunctionName.unwrap(value): java.lang.String
        )
      )(_.functionName)
      .optionallyWith(
        functionAlias.map(value =>
          LambdaFunctionAlias.unwrap(value): java.lang.String
        )
      )(_.functionAlias)
      .optionallyWith(
        currentVersion.map(value => Version.unwrap(value): java.lang.String)
      )(_.currentVersion)
      .optionallyWith(
        targetVersion.map(value => Version.unwrap(value): java.lang.String)
      )(_.targetVersion)
      .optionallyWith(
        targetVersionWeight.map(value =>
          TrafficWeight.unwrap(value): java.lang.Double
        )
      )(_.targetVersionWeight)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.LambdaFunctionInfo.ReadOnly =
    zio.aws.codedeploy.model.LambdaFunctionInfo.wrap(buildAwsValue())
}
object LambdaFunctionInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.LambdaFunctionInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.LambdaFunctionInfo =
      zio.aws.codedeploy.model.LambdaFunctionInfo(
        functionName.map(value => value),
        functionAlias.map(value => value),
        currentVersion.map(value => value),
        targetVersion.map(value => value),
        targetVersionWeight.map(value => value)
      )
    def functionName: Optional[LambdaFunctionName]
    def functionAlias: Optional[LambdaFunctionAlias]
    def currentVersion: Optional[Version]
    def targetVersion: Optional[Version]
    def targetVersionWeight: Optional[TrafficWeight]
    def getFunctionName: ZIO[Any, AwsError, LambdaFunctionName] =
      AwsError.unwrapOptionField("functionName", functionName)
    def getFunctionAlias: ZIO[Any, AwsError, LambdaFunctionAlias] =
      AwsError.unwrapOptionField("functionAlias", functionAlias)
    def getCurrentVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("currentVersion", currentVersion)
    def getTargetVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("targetVersion", targetVersion)
    def getTargetVersionWeight: ZIO[Any, AwsError, TrafficWeight] =
      AwsError.unwrapOptionField("targetVersionWeight", targetVersionWeight)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.LambdaFunctionInfo
  ) extends zio.aws.codedeploy.model.LambdaFunctionInfo.ReadOnly {
    override val functionName: Optional[LambdaFunctionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.functionName())
        .map(value =>
          zio.aws.codedeploy.model.primitives.LambdaFunctionName(value)
        )
    override val functionAlias: Optional[LambdaFunctionAlias] =
      zio.aws.core.internal
        .optionalFromNullable(impl.functionAlias())
        .map(value =>
          zio.aws.codedeploy.model.primitives.LambdaFunctionAlias(value)
        )
    override val currentVersion: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.currentVersion())
      .map(value => zio.aws.codedeploy.model.primitives.Version(value))
    override val targetVersion: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.targetVersion())
      .map(value => zio.aws.codedeploy.model.primitives.Version(value))
    override val targetVersionWeight: Optional[TrafficWeight] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetVersionWeight())
        .map(value => zio.aws.codedeploy.model.primitives.TrafficWeight(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.LambdaFunctionInfo
  ): zio.aws.codedeploy.model.LambdaFunctionInfo.ReadOnly = new Wrapper(impl)
}
