package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{NextToken, ApplicationName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListApplicationsResponse(
    applications: Optional[Iterable[ApplicationName]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.ListApplicationsResponse = {
    import ListApplicationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.ListApplicationsResponse
      .builder()
      .optionallyWith(
        applications.map(value =>
          value.map { item =>
            ApplicationName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.applications)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.ListApplicationsResponse.ReadOnly =
    zio.aws.codedeploy.model.ListApplicationsResponse.wrap(buildAwsValue())
}
object ListApplicationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.ListApplicationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.ListApplicationsResponse =
      zio.aws.codedeploy.model.ListApplicationsResponse(
        applications.map(value => value),
        nextToken.map(value => value)
      )
    def applications: Optional[List[ApplicationName]]
    def nextToken: Optional[NextToken]
    def getApplications: ZIO[Any, AwsError, List[ApplicationName]] =
      AwsError.unwrapOptionField("applications", applications)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.ListApplicationsResponse
  ) extends zio.aws.codedeploy.model.ListApplicationsResponse.ReadOnly {
    override val applications: Optional[List[ApplicationName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.primitives.ApplicationName(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codedeploy.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.ListApplicationsResponse
  ): zio.aws.codedeploy.model.ListApplicationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
