package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.DeploymentConfigId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDeploymentConfigResponse(
    deploymentConfigId: Optional[DeploymentConfigId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.CreateDeploymentConfigResponse = {
    import CreateDeploymentConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.CreateDeploymentConfigResponse
      .builder()
      .optionallyWith(
        deploymentConfigId.map(value =>
          DeploymentConfigId.unwrap(value): java.lang.String
        )
      )(_.deploymentConfigId)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.CreateDeploymentConfigResponse.ReadOnly =
    zio.aws.codedeploy.model.CreateDeploymentConfigResponse
      .wrap(buildAwsValue())
}
object CreateDeploymentConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.CreateDeploymentConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.CreateDeploymentConfigResponse =
      zio.aws.codedeploy.model
        .CreateDeploymentConfigResponse(deploymentConfigId.map(value => value))
    def deploymentConfigId: Optional[DeploymentConfigId]
    def getDeploymentConfigId: ZIO[Any, AwsError, DeploymentConfigId] =
      AwsError.unwrapOptionField("deploymentConfigId", deploymentConfigId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.CreateDeploymentConfigResponse
  ) extends zio.aws.codedeploy.model.CreateDeploymentConfigResponse.ReadOnly {
    override val deploymentConfigId: Optional[DeploymentConfigId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentConfigId())
        .map(value =>
          zio.aws.codedeploy.model.primitives.DeploymentConfigId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.CreateDeploymentConfigResponse
  ): zio.aws.codedeploy.model.CreateDeploymentConfigResponse.ReadOnly =
    new Wrapper(impl)
}
