package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{
  LogTail,
  LifecycleMessage,
  ScriptName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Diagnostics(
    errorCode: Optional[zio.aws.codedeploy.model.LifecycleErrorCode] =
      Optional.Absent,
    scriptName: Optional[ScriptName] = Optional.Absent,
    message: Optional[LifecycleMessage] = Optional.Absent,
    logTail: Optional[LogTail] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.Diagnostics = {
    import Diagnostics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.Diagnostics
      .builder()
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(
        scriptName.map(value => ScriptName.unwrap(value): java.lang.String)
      )(_.scriptName)
      .optionallyWith(
        message.map(value => LifecycleMessage.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        logTail.map(value => LogTail.unwrap(value): java.lang.String)
      )(_.logTail)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.Diagnostics.ReadOnly =
    zio.aws.codedeploy.model.Diagnostics.wrap(buildAwsValue())
}
object Diagnostics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.Diagnostics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.Diagnostics =
      zio.aws.codedeploy.model.Diagnostics(
        errorCode.map(value => value),
        scriptName.map(value => value),
        message.map(value => value),
        logTail.map(value => value)
      )
    def errorCode: Optional[zio.aws.codedeploy.model.LifecycleErrorCode]
    def scriptName: Optional[ScriptName]
    def message: Optional[LifecycleMessage]
    def logTail: Optional[LogTail]
    def getErrorCode
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.LifecycleErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getScriptName: ZIO[Any, AwsError, ScriptName] =
      AwsError.unwrapOptionField("scriptName", scriptName)
    def getMessage: ZIO[Any, AwsError, LifecycleMessage] =
      AwsError.unwrapOptionField("message", message)
    def getLogTail: ZIO[Any, AwsError, LogTail] =
      AwsError.unwrapOptionField("logTail", logTail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.Diagnostics
  ) extends zio.aws.codedeploy.model.Diagnostics.ReadOnly {
    override val errorCode
        : Optional[zio.aws.codedeploy.model.LifecycleErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value => zio.aws.codedeploy.model.LifecycleErrorCode.wrap(value))
    override val scriptName: Optional[ScriptName] = zio.aws.core.internal
      .optionalFromNullable(impl.scriptName())
      .map(value => zio.aws.codedeploy.model.primitives.ScriptName(value))
    override val message: Optional[LifecycleMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.codedeploy.model.primitives.LifecycleMessage(value))
    override val logTail: Optional[LogTail] = zio.aws.core.internal
      .optionalFromNullable(impl.logTail())
      .map(value => zio.aws.codedeploy.model.primitives.LogTail(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.Diagnostics
  ): zio.aws.codedeploy.model.Diagnostics.ReadOnly = new Wrapper(impl)
}
