package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetDeploymentResponse(
    deploymentInfo: Optional[zio.aws.codedeploy.model.DeploymentInfo] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.GetDeploymentResponse = {
    import GetDeploymentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.GetDeploymentResponse
      .builder()
      .optionallyWith(deploymentInfo.map(value => value.buildAwsValue()))(
        _.deploymentInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.GetDeploymentResponse.ReadOnly =
    zio.aws.codedeploy.model.GetDeploymentResponse.wrap(buildAwsValue())
}
object GetDeploymentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.GetDeploymentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.GetDeploymentResponse =
      zio.aws.codedeploy.model
        .GetDeploymentResponse(deploymentInfo.map(value => value.asEditable))
    def deploymentInfo
        : Optional[zio.aws.codedeploy.model.DeploymentInfo.ReadOnly]
    def getDeploymentInfo
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.DeploymentInfo.ReadOnly] =
      AwsError.unwrapOptionField("deploymentInfo", deploymentInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.GetDeploymentResponse
  ) extends zio.aws.codedeploy.model.GetDeploymentResponse.ReadOnly {
    override val deploymentInfo
        : Optional[zio.aws.codedeploy.model.DeploymentInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentInfo())
        .map(value => zio.aws.codedeploy.model.DeploymentInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.GetDeploymentResponse
  ): zio.aws.codedeploy.model.GetDeploymentResponse.ReadOnly = new Wrapper(impl)
}
