package zio.aws.codedeploy.model
import zio.prelude.data.Optional
import zio.aws.codedeploy.model.primitives.Duration
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DeploymentReadyOption(
    actionOnTimeout: Optional[zio.aws.codedeploy.model.DeploymentReadyAction] =
      Optional.Absent,
    waitTimeInMinutes: Optional[Duration] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.DeploymentReadyOption = {
    import DeploymentReadyOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.DeploymentReadyOption
      .builder()
      .optionallyWith(actionOnTimeout.map(value => value.unwrap))(
        _.actionOnTimeout
      )
      .optionallyWith(
        waitTimeInMinutes.map(value => Duration.unwrap(value): Integer)
      )(_.waitTimeInMinutes)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.DeploymentReadyOption.ReadOnly =
    zio.aws.codedeploy.model.DeploymentReadyOption.wrap(buildAwsValue())
}
object DeploymentReadyOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.DeploymentReadyOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.DeploymentReadyOption =
      zio.aws.codedeploy.model.DeploymentReadyOption(
        actionOnTimeout.map(value => value),
        waitTimeInMinutes.map(value => value)
      )
    def actionOnTimeout
        : Optional[zio.aws.codedeploy.model.DeploymentReadyAction]
    def waitTimeInMinutes: Optional[Duration]
    def getActionOnTimeout
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.DeploymentReadyAction] =
      AwsError.unwrapOptionField("actionOnTimeout", actionOnTimeout)
    def getWaitTimeInMinutes: ZIO[Any, AwsError, Duration] =
      AwsError.unwrapOptionField("waitTimeInMinutes", waitTimeInMinutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.DeploymentReadyOption
  ) extends zio.aws.codedeploy.model.DeploymentReadyOption.ReadOnly {
    override val actionOnTimeout
        : Optional[zio.aws.codedeploy.model.DeploymentReadyAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionOnTimeout())
        .map(value =>
          zio.aws.codedeploy.model.DeploymentReadyAction.wrap(value)
        )
    override val waitTimeInMinutes: Optional[Duration] = zio.aws.core.internal
      .optionalFromNullable(impl.waitTimeInMinutes())
      .map(value => zio.aws.codedeploy.model.primitives.Duration(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.DeploymentReadyOption
  ): zio.aws.codedeploy.model.DeploymentReadyOption.ReadOnly = new Wrapper(impl)
}
