package zio.aws.codedeploy.model
import scala.jdk.CollectionConverters.*
sealed trait DeploymentType {
  def unwrap: software.amazon.awssdk.services.codedeploy.model.DeploymentType
}
object DeploymentType {
  def wrap(
      value: software.amazon.awssdk.services.codedeploy.model.DeploymentType
  ): zio.aws.codedeploy.model.DeploymentType = value match {
    case software.amazon.awssdk.services.codedeploy.model.DeploymentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codedeploy.model.DeploymentType.IN_PLACE =>
      val r = IN_PLACE
      r
    case software.amazon.awssdk.services.codedeploy.model.DeploymentType.BLUE_GREEN =>
      val r = BLUE_GREEN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codedeploy.model.DeploymentType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentType =
      software.amazon.awssdk.services.codedeploy.model.DeploymentType.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PLACE extends zio.aws.codedeploy.model.DeploymentType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentType =
      software.amazon.awssdk.services.codedeploy.model.DeploymentType.IN_PLACE
  }
  case object BLUE_GREEN extends zio.aws.codedeploy.model.DeploymentType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentType =
      software.amazon.awssdk.services.codedeploy.model.DeploymentType.BLUE_GREEN
  }
}
