package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{NextToken, TargetId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDeploymentTargetsResponse(
    targetIds: Optional[Iterable[TargetId]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsResponse = {
    import ListDeploymentTargetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsResponse
      .builder()
      .optionallyWith(
        targetIds.map(value =>
          value.map { item =>
            TargetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targetIds)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.ListDeploymentTargetsResponse.ReadOnly =
    zio.aws.codedeploy.model.ListDeploymentTargetsResponse.wrap(buildAwsValue())
}
object ListDeploymentTargetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.ListDeploymentTargetsResponse =
      zio.aws.codedeploy.model.ListDeploymentTargetsResponse(
        targetIds.map(value => value),
        nextToken.map(value => value)
      )
    def targetIds: Optional[List[TargetId]]
    def nextToken: Optional[NextToken]
    def getTargetIds: ZIO[Any, AwsError, List[TargetId]] =
      AwsError.unwrapOptionField("targetIds", targetIds)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsResponse
  ) extends zio.aws.codedeploy.model.ListDeploymentTargetsResponse.ReadOnly {
    override val targetIds: Optional[List[TargetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.targetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codedeploy.model.primitives.TargetId(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codedeploy.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsResponse
  ): zio.aws.codedeploy.model.ListDeploymentTargetsResponse.ReadOnly =
    new Wrapper(impl)
}
