package zio.aws.codedeploy.model
import scala.jdk.CollectionConverters.*
sealed trait ApplicationRevisionSortBy {
  def unwrap: software.amazon.awssdk.services.codedeploy.model.ApplicationRevisionSortBy
}
object ApplicationRevisionSortBy {
  def wrap(
      value: software.amazon.awssdk.services.codedeploy.model.ApplicationRevisionSortBy
  ): zio.aws.codedeploy.model.ApplicationRevisionSortBy = value match {
    case software.amazon.awssdk.services.codedeploy.model.ApplicationRevisionSortBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codedeploy.model.ApplicationRevisionSortBy.REGISTER_TIME =>
      val r = registerTime
      r
    case software.amazon.awssdk.services.codedeploy.model.ApplicationRevisionSortBy.FIRST_USED_TIME =>
      val r = firstUsedTime
      r
    case software.amazon.awssdk.services.codedeploy.model.ApplicationRevisionSortBy.LAST_USED_TIME =>
      val r = lastUsedTime
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codedeploy.model.ApplicationRevisionSortBy {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ApplicationRevisionSortBy =
      software.amazon.awssdk.services.codedeploy.model.ApplicationRevisionSortBy.UNKNOWN_TO_SDK_VERSION
  }
  case object registerTime
      extends zio.aws.codedeploy.model.ApplicationRevisionSortBy {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ApplicationRevisionSortBy =
      software.amazon.awssdk.services.codedeploy.model.ApplicationRevisionSortBy.REGISTER_TIME
  }
  case object firstUsedTime
      extends zio.aws.codedeploy.model.ApplicationRevisionSortBy {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ApplicationRevisionSortBy =
      software.amazon.awssdk.services.codedeploy.model.ApplicationRevisionSortBy.FIRST_USED_TIME
  }
  case object lastUsedTime
      extends zio.aws.codedeploy.model.ApplicationRevisionSortBy {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ApplicationRevisionSortBy =
      software.amazon.awssdk.services.codedeploy.model.ApplicationRevisionSortBy.LAST_USED_TIME
  }
}
