package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codedeploy.model.primitives.ApplicationName
import scala.jdk.CollectionConverters.*
final case class BatchGetApplicationsRequest(
    applicationNames: Iterable[ApplicationName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationsRequest = {
    import BatchGetApplicationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationsRequest
      .builder()
      .applicationNames(applicationNames.map { item =>
        ApplicationName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.BatchGetApplicationsRequest.ReadOnly =
    zio.aws.codedeploy.model.BatchGetApplicationsRequest.wrap(buildAwsValue())
}
object BatchGetApplicationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.BatchGetApplicationsRequest =
      zio.aws.codedeploy.model.BatchGetApplicationsRequest(applicationNames)
    def applicationNames: List[ApplicationName]
    def getApplicationNames: ZIO[Any, Nothing, List[ApplicationName]] =
      ZIO.succeed(applicationNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationsRequest
  ) extends zio.aws.codedeploy.model.BatchGetApplicationsRequest.ReadOnly {
    override val applicationNames: List[ApplicationName] = impl
      .applicationNames()
      .asScala
      .map { item =>
        zio.aws.codedeploy.model.primitives.ApplicationName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationsRequest
  ): zio.aws.codedeploy.model.BatchGetApplicationsRequest.ReadOnly =
    new Wrapper(impl)
}
